/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.NumberAwareStringComparator;

class NumberAwareStringComparatorTest {
    NumberAwareStringComparatorTest() {
    }

    @Test
    void shouldHandleSingleNumber() {
        NumberAwareStringComparatorTest.assertLesser("123", "456");
        NumberAwareStringComparatorTest.assertLesser("123", "1234");
        NumberAwareStringComparatorTest.assertLesser("1", "12");
        NumberAwareStringComparatorTest.assertSame("123", "123");
        NumberAwareStringComparatorTest.assertSame("001", "1");
        NumberAwareStringComparatorTest.assertGreater("555", "66");
    }

    @Test
    void shouldHandleMixedAlthoughSimilarNumbersAndStrings() {
        NumberAwareStringComparatorTest.assertLesser("same-1-thing-45", "same-12-thing-45");
        NumberAwareStringComparatorTest.assertGreater("same-2-thing-46", "same-2-thing-45");
    }

    @Test
    void shouldHandleMixedAndDifferentNumbersAndStrings() {
        NumberAwareStringComparatorTest.assertLesser("same123thing456", "same123thing456andmore");
        NumberAwareStringComparatorTest.assertGreater("same12", "same1thing456andmore");
    }

    @Test
    void shouldHandleBigNumbers() {
        NumberAwareStringComparatorTest.assertGreater("same-9999999999999999999999999999999999999", "same-9999999999999999999999999999999999998");
        NumberAwareStringComparatorTest.assertLesser("same-9", "same-8999999999999999999999999999999999998");
    }

    private static void assertLesser(String first, String other) {
        Assertions.assertTrue((NumberAwareStringComparatorTest.compare(first, other) < 0 ? 1 : 0) != 0);
    }

    private static void assertSame(String first, String other) {
        Assertions.assertEquals((int)0, (int)NumberAwareStringComparatorTest.compare(first, other));
    }

    private static void assertGreater(String first, String other) {
        Assertions.assertTrue((NumberAwareStringComparatorTest.compare(first, other) > 0 ? 1 : 0) != 0);
    }

    private static int compare(String first, String other) {
        return NumberAwareStringComparator.INSTANCE.compare(first, other);
    }
}

