/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ByteBufferBackedChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class ChannelBufferWrapper
implements ChannelBuffer {
    private final InMemoryClosableChannel delegate;

    public ChannelBufferWrapper(InMemoryClosableChannel delegate) {
        this.delegate = delegate;
    }

    public ChannelBufferFactory factory() {
        throw new UnsupportedOperationException();
    }

    public int capacity() {
        return this.delegate.capacity();
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean isDirect() {
        return false;
    }

    public int readerIndex() {
        return this.delegate.readerPosition();
    }

    public void readerIndex(int readerIndex) {
        this.delegate.positionReader(readerIndex);
    }

    public int writerIndex() {
        return this.delegate.writerPosition();
    }

    public void writerIndex(int writerIndex) {
        this.delegate.positionWriter(writerIndex);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.delegate.positionReader(readerIndex);
        this.delegate.positionWriter(writerIndex);
    }

    public int readableBytes() {
        return this.delegate.availableBytesToRead();
    }

    public int writableBytes() {
        return this.delegate.availableBytesToWrite();
    }

    public boolean readable() {
        return this.delegate.writerPosition() > this.delegate.readerPosition();
    }

    public boolean writable() {
        return this.delegate.writerPosition() < this.delegate.capacity();
    }

    public void clear() {
        this.delegate.reset();
    }

    public void markReaderIndex() {
        throw new UnsupportedOperationException();
    }

    public void resetReaderIndex() {
        throw new UnsupportedOperationException();
    }

    public void markWriterIndex() {
        throw new UnsupportedOperationException();
    }

    public void resetWriterIndex() {
        throw new UnsupportedOperationException();
    }

    public void discardReadBytes() {
        throw new UnsupportedOperationException();
    }

    public void ensureWritableBytes(int writableBytes) {
        boolean availableBytes;
        boolean bl = availableBytes = this.delegate.availableBytesToWrite() < writableBytes;
        if (availableBytes) {
            throw new IndexOutOfBoundsException("Wanted " + writableBytes + " to be available for writing, but there were only " + availableBytes + " available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            byte by = this.readByte();
            return by;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getUnsignedByte(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            short s = this.readUnsignedByte();
            return s;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            short s = this.readShort();
            return s;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnsignedShort(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            int n = this.readUnsignedShort();
            return n;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMedium(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            int n = this.readMedium();
            return n;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnsignedMedium(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            int n = this.readUnsignedMedium();
            return n;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            int n = this.readInt();
            return n;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnsignedInt(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            long l = this.readUnsignedInt();
            return l;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            long l = this.readLong();
            return l;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            char c = this.readChar();
            return c;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            float f = this.readFloat();
            return f;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int index) {
        int pos = this.delegate.positionReader(index);
        try {
            double d = this.readDouble();
            return d;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, ChannelBuffer dst) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, ChannelBuffer dst, int length) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst, length);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst, dstIndex, length);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, byte[] dst) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst, dstIndex, length);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, ByteBuffer dst) {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(dst);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        int pos = this.delegate.positionReader(index);
        try {
            this.readBytes(out, length);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        int pos = this.delegate.positionReader(index);
        try {
            int n = this.readBytes(out, length);
            return n;
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int index, int value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeByte(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int index, int value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeShort(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedium(int index, int value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeMedium(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int index, int value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeInt(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int index, long value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeLong(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChar(int index, int value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeChar(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int index, float value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeFloat(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int index, double value) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeDouble(value);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, ChannelBuffer src) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, ChannelBuffer src, int length) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src, length);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src, srcIndex, length);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, byte[] src) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src, srcIndex, length);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, ByteBuffer src) {
        int pos = this.delegate.positionWriter(index);
        try {
            this.writeBytes(src);
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(int index, InputStream in, int length) throws IOException {
        int pos = this.delegate.positionWriter(index);
        try {
            int n = this.writeBytes(in, length);
            return n;
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int pos = this.delegate.positionWriter(index);
        try {
            int n = this.writeBytes(in, length);
            return n;
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZero(int index, int length) {
        int pos = this.delegate.positionWriter(index);
        try {
            for (int i = 0; i < length; ++i) {
                this.writeByte(0);
            }
        }
        finally {
            this.delegate.positionWriter(pos);
        }
    }

    public byte readByte() {
        try {
            return this.delegate.get();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    private IndexOutOfBoundsException outOfBounds(ReadPastEndException e) {
        return new IndexOutOfBoundsException("Tried to read past the end " + (Object)((Object)e));
    }

    public short readUnsignedByte() {
        try {
            return (short)(this.delegate.get() & 0xFF);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public short readShort() {
        try {
            return this.delegate.getShort();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public int readUnsignedShort() {
        try {
            return this.delegate.getShort() & 0xFFFF;
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public int readMedium() {
        try {
            short low = this.delegate.getShort();
            byte high = this.delegate.get();
            return low | high << 16;
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public int readUnsignedMedium() {
        return this.readMedium();
    }

    public int readInt() {
        try {
            return this.delegate.getInt();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public long readUnsignedInt() {
        try {
            return (long)this.delegate.getInt() & 0xFFFFFFFFL;
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public long readLong() {
        try {
            return this.delegate.getLong();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public char readChar() {
        try {
            short low = this.delegate.get();
            short high = this.delegate.get();
            return (char)(low | high << 8);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public float readFloat() {
        try {
            return this.delegate.getFloat();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public double readDouble() {
        try {
            return this.delegate.getDouble();
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public ChannelBuffer readBytes(int length) {
        try {
            byte[] array = new byte[length];
            this.delegate.get(array, length);
            return new ByteBufferBackedChannelBuffer(ByteBuffer.wrap(array));
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public ChannelBuffer readBytes(ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer readSlice(int length) {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer readSlice(ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public void readBytes(ChannelBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    public void readBytes(ChannelBuffer dst, int length) {
        try {
            byte[] array = new byte[length];
            this.delegate.get(array, length);
            dst.writeBytes(array);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        dst.readerIndex(dstIndex);
        this.readBytes(dst, length);
    }

    public void readBytes(byte[] dst) {
        try {
            this.delegate.get(dst, dst.length);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        try {
            byte[] array = new byte[length];
            this.delegate.get(array, length);
            System.arraycopy(array, 0, dst, dstIndex, length);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public void readBytes(ByteBuffer dst) {
        byte[] array = new byte[dst.remaining()];
        try {
            this.delegate.get(array, array.length);
            dst.put(array);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        byte[] array = new byte[length];
        try {
            this.delegate.get(array, length);
            out.write(array);
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        byte[] array = new byte[length];
        try {
            this.delegate.get(array, length);
            return out.write(ByteBuffer.wrap(array));
        }
        catch (ReadPastEndException e) {
            throw this.outOfBounds(e);
        }
    }

    public void skipBytes(int length) {
        this.delegate.positionReader(this.delegate.readerPosition() + length);
    }

    public int skipBytes(ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public void writeByte(int value) {
        try {
            this.delegate.put((byte)value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    private RuntimeException writeException(IOException e) {
        return new RuntimeException(e);
    }

    public void writeShort(int value) {
        try {
            this.delegate.putShort((short)value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeMedium(int value) {
        try {
            this.delegate.putShort((short)value);
            this.delegate.put((byte)(value >>> 16));
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeInt(int value) {
        try {
            this.delegate.putInt(value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeLong(long value) {
        try {
            this.delegate.putLong(value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeChar(int value) {
        try {
            this.delegate.put((byte)value);
            this.delegate.put((byte)(value >>> 8));
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeFloat(float value) {
        try {
            this.delegate.putFloat(value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeDouble(double value) {
        try {
            this.delegate.putDouble(value);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeBytes(ChannelBuffer src) {
        this.writeBytes(src, src.readableBytes());
    }

    public void writeBytes(ChannelBuffer src, int length) {
        try {
            byte[] array = new byte[length];
            src.readBytes(array);
            this.delegate.put(array, array.length);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        src.readerIndex(srcIndex);
        this.writeBytes(src, length);
    }

    public void writeBytes(byte[] src) {
        try {
            this.delegate.put(src, src.length);
        }
        catch (IOException e) {
            throw this.writeException(e);
        }
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        if (srcIndex > 0) {
            byte[] array = new byte[length];
            System.arraycopy(src, 0, array, srcIndex, length);
            src = array;
        }
        this.writeBytes(src);
    }

    public void writeBytes(ByteBuffer src) {
        byte[] array = new byte[src.remaining()];
        src.get(array);
        this.writeBytes(array);
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        byte[] array = new byte[length];
        int read = in.read(array);
        this.writeBytes(array, 0, read);
        return read;
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        byte[] array = new byte[length];
        int read = in.read(ByteBuffer.wrap(array));
        this.writeBytes(array, 0, read);
        return read;
    }

    public void writeZero(int length) {
        for (int i = 0; i < length; ++i) {
            this.writeByte(0);
        }
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        int pos = this.delegate.positionReader(fromIndex);
        try {
            int thisPos;
            while (this.delegate.readerPosition() < toIndex) {
                thisPos = this.delegate.readerPosition();
                if (this.delegate.get() != value) continue;
                int n = thisPos;
                return n;
            }
            thisPos = -1;
            return thisPos;
        }
        catch (ReadPastEndException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.delegate.positionReader(pos);
        }
    }

    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public int bytesBefore(byte value) {
        int index = this.indexOf(this.readerIndex(), this.writerIndex(), value);
        return index == -1 ? -1 : index - this.readerIndex();
    }

    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public int bytesBefore(int length, byte value) {
        return this.bytesBefore(this.readerIndex(), length, value);
    }

    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public int bytesBefore(int index, int length, byte value) {
        int foundIndex = this.indexOf(index, index + length, value);
        return foundIndex == -1 ? -1 : foundIndex - index;
    }

    public int bytesBefore(int index, int length, ChannelBufferIndexFinder indexFinder) {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer copy() {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer slice() {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer slice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ChannelBuffer duplicate() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer toByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] toByteBuffers() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString(int index, int length, Charset charset) {
        return this.toString();
    }

    public String toString(String charsetName) {
        return this.toString();
    }

    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.toString();
    }

    public String toString(int index, int length, String charsetName) {
        return this.toString();
    }

    public String toString(int index, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.toString();
    }

    public int compareTo(ChannelBuffer buffer) {
        throw new UnsupportedOperationException();
    }
}

