/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.com.ComException;
import org.neo4j.com.MadeUpClient;
import org.neo4j.com.MadeUpWriter;

public class ClientCrashingWriter
implements MadeUpWriter {
    private final MadeUpClient client;
    private final int crashAtSize;
    private int totalSize;

    public ClientCrashingWriter(MadeUpClient client, int crashAtSize) {
        this.client = client;
        this.crashAtSize = crashAtSize;
    }

    @Override
    public void write(ReadableByteChannel data) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1000);
        while (true) {
            buffer.clear();
            try {
                int size = data.read(buffer);
                if (size == -1) break;
                if ((this.totalSize += size) < this.crashAtSize) continue;
                this.client.stop();
            }
            catch (IOException e) {
                throw new ComException((Throwable)e);
            }
        }
    }

    public int getSizeRead() {
        return this.totalSize;
    }
}

