/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class DataProducer
implements ReadableByteChannel {
    private int bytesLeftToProduce;
    private boolean closed;

    public DataProducer(int size) {
        this.bytesLeftToProduce = size;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.closed = true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int toFill;
        int leftToFill = toFill = Math.min(dst.remaining(), this.bytesLeftToProduce);
        if (toFill <= 0) {
            return -1;
        }
        while (leftToFill-- > 0) {
            dst.put((byte)5);
        }
        this.bytesLeftToProduce -= toFill;
        return toFill;
    }
}

