/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.MadeUpCommunicationInterface;
import org.neo4j.com.MadeUpServer;
import org.neo4j.com.MadeUpWriter;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public abstract class MadeUpClient
extends Client<MadeUpCommunicationInterface>
implements MadeUpCommunicationInterface {
    public MadeUpClient(int port, StoreId storeIdToExpect, int chunkSize, ResponseUnpacker responseUnpacker) {
        super(MadeUpClient.localhost(), port, null, (LogProvider)NullLogProvider.getInstance(), storeIdToExpect, 0x100000, 20000L, 20, chunkSize, responseUnpacker, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]), (RequestMonitor)new Monitors().newMonitor(RequestMonitor.class, new String[0]), (LogEntryReader)new VersionAwareLogEntryReader());
    }

    private static String localhost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    protected byte getInternalProtocolVersion() {
        return this.getProtocolVersion().getInternalProtocol();
    }

    @Override
    public Response<Integer> multiply(int value1, int value2) {
        Serializer serializer = buffer -> {
            buffer.writeInt(value1);
            buffer.writeInt(value2);
        };
        return this.sendRequest(MadeUpServer.MadeUpRequestType.MULTIPLY, this.getRequestContext(), serializer, Protocol.INTEGER_DESERIALIZER);
    }

    private RequestContext getRequestContext() {
        return new RequestContext(RequestContext.EMPTY.getEpoch(), RequestContext.EMPTY.machineId(), RequestContext.EMPTY.getEventIdentifier(), 2L, RequestContext.EMPTY.getChecksum());
    }

    @Override
    public Response<Void> fetchDataStream(MadeUpWriter writer, int dataSize) {
        Serializer serializer = buffer -> buffer.writeInt(dataSize);
        Deserializer deserializer = (buffer, temporaryBuffer) -> {
            writer.write((ReadableByteChannel)new BlockLogReader(buffer));
            return null;
        };
        return this.sendRequest(MadeUpServer.MadeUpRequestType.FETCH_DATA_STREAM, this.getRequestContext(), serializer, deserializer);
    }

    @Override
    public Response<Void> sendDataStream(ReadableByteChannel data) {
        Serializer serializer = buffer -> {
            try (BlockLogBuffer writer = new BlockLogBuffer(buffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));){
                writer.write(data);
            }
        };
        return this.sendRequest(MadeUpServer.MadeUpRequestType.SEND_DATA_STREAM, this.getRequestContext(), serializer, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Integer> throwException(String messageInException) {
        Serializer serializer = buffer -> Protocol.writeString((ChannelBuffer)buffer, (String)messageInException);
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(MadeUpServer.MadeUpRequestType.THROW_EXCEPTION, this.getRequestContext(), serializer, deserializer);
    }

    @Override
    public Response<Integer> streamBackTransactions(int responseToSendBack, int txCount) {
        Serializer serializer = buffer -> {
            buffer.writeInt(responseToSendBack);
            buffer.writeInt(txCount);
        };
        Deserializer integerDeserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(MadeUpServer.MadeUpRequestType.STREAM_BACK_TRANSACTIONS, this.getRequestContext(), serializer, integerDeserializer);
    }

    @Override
    public Response<Integer> informAboutTransactionObligations(int responseToSendBack, long desiredObligation) {
        Serializer serializer = buffer -> {
            buffer.writeInt(responseToSendBack);
            buffer.writeLong(desiredObligation);
        };
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(MadeUpServer.MadeUpRequestType.INFORM_ABOUT_TX_OBLIGATIONS, this.getRequestContext(), serializer, deserializer);
    }
}

