/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.MadeUpCommunicationInterface;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.ToChannelBufferWriter;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class MadeUpServer
extends Server<MadeUpCommunicationInterface, Void> {
    private volatile boolean responseWritten;
    private volatile boolean responseFailureEncountered;
    private final byte internalProtocolVersion;
    public static final int FRAME_LENGTH = 0x100000;

    public MadeUpServer(MadeUpCommunicationInterface requestTarget, final int port, byte internalProtocolVersion, byte applicationProtocolVersion, TxChecksumVerifier txVerifier, final int chunkSize) {
        super((Object)requestTarget, new Server.Configuration(){

            public long getOldChannelThreshold() {
                return 20000L;
            }

            public int getMaxConcurrentTransactions() {
                return 200;
            }

            public int getChunkSize() {
                return chunkSize;
            }

            public HostnamePort getServerAddress() {
                return new HostnamePort(null, port);
            }
        }, (LogProvider)NullLogProvider.getInstance(), 0x100000, new ProtocolVersion(applicationProtocolVersion, 2), txVerifier, Clocks.systemClock(), (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]), (RequestMonitor)new Monitors().newMonitor(RequestMonitor.class, new String[0]));
        this.internalProtocolVersion = internalProtocolVersion;
    }

    protected void responseWritten(RequestType<MadeUpCommunicationInterface> type, Channel channel, RequestContext context) {
        this.responseWritten = true;
    }

    protected void writeFailureResponse(Throwable exception, ChunkingChannelBuffer buffer) {
        this.responseFailureEncountered = true;
        super.writeFailureResponse(exception, buffer);
    }

    protected byte getInternalProtocolVersion() {
        return this.internalProtocolVersion;
    }

    protected RequestType<MadeUpCommunicationInterface> getRequestContext(byte id) {
        return MadeUpRequestType.values()[id];
    }

    protected void stopConversation(RequestContext context) {
    }

    public boolean responseHasBeenWritten() {
        return this.responseWritten;
    }

    public boolean responseFailureEncountered() {
        return this.responseFailureEncountered;
    }

    static enum MadeUpRequestType implements RequestType<MadeUpCommunicationInterface>
    {
        MULTIPLY((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Integer>(){

            public Response<Integer> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                int value1 = input.readInt();
                int value2 = input.readInt();
                return master.multiply(value1, value2);
            }
        }, Protocol.INTEGER_SERIALIZER),
        FETCH_DATA_STREAM((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Void>(){

            public Response<Void> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                int dataSize = input.readInt();
                return master.fetchDataStream(new ToChannelBufferWriter(target), dataSize);
            }
        }, Protocol.VOID_SERIALIZER),
        SEND_DATA_STREAM((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Response<Void> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                BlockLogReader reader = new BlockLogReader(input);
                try {
                    Response<Void> response = master.sendDataStream((ReadableByteChannel)reader);
                    return response;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }, Protocol.VOID_SERIALIZER){

            @Override
            public boolean responseShouldBeUnpacked() {
                return false;
            }
        }
        ,
        THROW_EXCEPTION((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Integer>(){

            public Response<Integer> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.throwException(Protocol.readString((ChannelBuffer)input));
            }
        }, Protocol.VOID_SERIALIZER),
        CAUSE_READ_CONTEXT_EXCEPTION((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Integer>(){

            public Response<Integer> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                throw new AssertionError((Object)"Test should not reach this far, it should fail while reading the request context.");
            }
        }, Protocol.VOID_SERIALIZER),
        STREAM_BACK_TRANSACTIONS((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Integer>(){

            public Response<Integer> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.streamBackTransactions(input.readInt(), input.readInt());
            }
        }, Protocol.INTEGER_SERIALIZER),
        INFORM_ABOUT_TX_OBLIGATIONS((TargetCaller)new TargetCaller<MadeUpCommunicationInterface, Integer>(){

            public Response<Integer> call(MadeUpCommunicationInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.informAboutTransactionObligations(input.readInt(), input.readLong());
            }
        }, Protocol.INTEGER_SERIALIZER);

        private final TargetCaller masterCaller;
        private final ObjectSerializer serializer;

        private MadeUpRequestType(TargetCaller masterCaller, ObjectSerializer serializer) {
            this.masterCaller = masterCaller;
            this.serializer = serializer;
        }

        public TargetCaller getTargetCaller() {
            return this.masterCaller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public boolean responseShouldBeUnpacked() {
            return true;
        }
    }
}

