/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.neo4j.com.KnownDataByteChannel;
import org.neo4j.com.MadeUpCommunicationInterface;
import org.neo4j.com.MadeUpException;
import org.neo4j.com.MadeUpWriter;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class MadeUpServerImplementation
implements MadeUpCommunicationInterface {
    private final StoreId storeIdToRespondWith;
    private boolean gotCalled;

    public MadeUpServerImplementation(StoreId storeIdToRespondWith) {
        this.storeIdToRespondWith = storeIdToRespondWith;
    }

    @Override
    public Response<Integer> multiply(int value1, int value2) {
        this.gotCalled = true;
        return new TransactionStreamResponse((Object)(value1 * value2), this.storeIdToRespondWith, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    @Override
    public Response<Void> fetchDataStream(MadeUpWriter writer, int dataSize) {
        writer.write(new KnownDataByteChannel(dataSize));
        return this.emptyResponse();
    }

    private Response<Void> emptyResponse() {
        return new TransactionStreamResponse(null, this.storeIdToRespondWith, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    @Override
    public Response<Void> sendDataStream(ReadableByteChannel data) {
        this.readFully(data);
        return this.emptyResponse();
    }

    @Override
    public Response<Integer> streamBackTransactions(int responseToSendBack, final int txCount) {
        TransactionStream transactions = new TransactionStream(){

            public void accept(Visitor<CommittedTransactionRepresentation, Exception> visitor) throws Exception {
                for (int i = 1; i <= txCount; ++i) {
                    CommittedTransactionRepresentation transaction = MadeUpServerImplementation.this.createTransaction(1L + (long)i);
                    visitor.visit((Object)transaction);
                }
            }
        };
        return new TransactionStreamResponse((Object)responseToSendBack, this.storeIdToRespondWith, transactions, ResourceReleaser.NO_OP);
    }

    @Override
    public Response<Integer> informAboutTransactionObligations(int responseToSendBack, long desiredObligation) {
        return new TransactionObligationResponse((Object)responseToSendBack, this.storeIdToRespondWith, desiredObligation, ResourceReleaser.NO_OP);
    }

    protected CommittedTransactionRepresentation createTransaction(long txId) {
        return new CommittedTransactionRepresentation(new LogEntryStart(0, 0, 0L, 0L, new byte[0], null), this.transaction(txId), (LogEntryCommit)new OnePhaseCommit(txId, 0L));
    }

    private TransactionRepresentation transaction(long txId) {
        ArrayList<Command.NodeCommand> commands = new ArrayList<Command.NodeCommand>();
        NodeRecord node = new NodeRecord(txId);
        node.setInUse(true);
        commands.add(new Command.NodeCommand(new NodeRecord(txId), node));
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return transaction;
    }

    private void readFully(ReadableByteChannel data) {
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        try {
            do {
                buffer.clear();
            } while (data.read(buffer) != -1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response<Integer> throwException(String messageInException) {
        throw new MadeUpException(messageInException, new Exception("The cause of it"));
    }

    public boolean gotCalled() {
        return this.gotCalled;
    }
}

