/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import org.neo4j.com.MadeUpServer;
import org.neo4j.com.MadeUpServerImplementation;
import org.neo4j.com.ServerInterface;
import org.neo4j.com.StartupData;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.test.subprocess.SubProcess;

public class MadeUpServerProcess
extends SubProcess<ServerInterface, StartupData>
implements ServerInterface {
    private static final long serialVersionUID = 1L;
    public static final int PORT = 8888;
    private volatile transient MadeUpServer server;

    protected void startup(StartupData data) throws Throwable {
        MadeUpServerImplementation implementation = new MadeUpServerImplementation(StoreIdTestFactory.newStoreIdForCurrentVersion(data.creationTime, data.storeId, data.creationTime, data.storeId));
        MadeUpServer localServer = new MadeUpServer(implementation, 8888, data.internalProtocolVersion, data.applicationProtocolVersion, TxChecksumVerifier.ALWAYS_MATCH, data.chunkSize);
        localServer.init();
        localServer.start();
        this.server = localServer;
    }

    @Override
    public void awaitStarted() {
        try {
            long endTime = System.currentTimeMillis() + 20000L;
            while (this.server == null && System.currentTimeMillis() < endTime) {
                Thread.sleep(10L);
            }
            if (this.server == null) {
                throw new RuntimeException("Couldn't start server, wait timeout");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void shutdown(boolean normal) {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.shutdown();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                MadeUpServerProcess.this.shutdownProcess();
            }
        }.start();
    }

    protected void shutdownProcess() {
        super.shutdown();
    }
}

