/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.netty.buffer.ChannelBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.com.ChannelBufferWrapper;
import org.neo4j.com.Protocol;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.StorageCommand;

public class ProtocolTest {
    @Test
    public void shouldSerializeAndDeserializeTransactionRepresentation() throws Exception {
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.justOneNode());
        byte[] additionalHeader = "extra".getBytes();
        int masterId = 1;
        int authorId = 2;
        long timeStarted = 12345L;
        long lastTxWhenStarted = 12L;
        long timeCommitted = timeStarted + 10L;
        transaction.setHeader(additionalHeader, masterId, authorId, timeStarted, lastTxWhenStarted, timeCommitted, -1);
        Protocol.TransactionSerializer serializer = new Protocol.TransactionSerializer((TransactionRepresentation)transaction);
        ChannelBufferWrapper buffer = new ChannelBufferWrapper(new InMemoryClosableChannel());
        serializer.write((ChannelBuffer)buffer);
        Assert.assertEquals((Object)"nioneodb", (Object)Protocol.readString((ChannelBuffer)buffer));
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
        TransactionRepresentation readTransaction = new Protocol.TransactionRepresentationDeserializer((LogEntryReader)reader).read((ChannelBuffer)buffer, ByteBuffer.allocate(1000));
        Assert.assertArrayEquals((byte[])additionalHeader, (byte[])readTransaction.additionalHeader());
        Assert.assertEquals((long)masterId, (long)readTransaction.getMasterId());
        Assert.assertEquals((long)authorId, (long)readTransaction.getAuthorId());
        Assert.assertEquals((long)timeStarted, (long)readTransaction.getTimeStarted());
        Assert.assertEquals((long)lastTxWhenStarted, (long)readTransaction.getLatestCommittedTxWhenStarted());
        Assert.assertEquals((long)timeCommitted, (long)readTransaction.getTimeCommitted());
    }

    private Collection<StorageCommand> justOneNode() {
        NodeRecord node = new NodeRecord(0L);
        node.setInUse(true);
        return Arrays.asList(new Command.NodeCommand(new NodeRecord(node.getId()), node));
    }
}

