/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ByteBufferBackedChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol214;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RecordingChannel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Serializer;
import org.neo4j.com.Server;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class ServerTest {
    private final Protocol protocol = new Protocol214(1024, 0, 2);
    private final TxChecksumVerifier checksumVerifier = (TxChecksumVerifier)Mockito.mock(TxChecksumVerifier.class);
    private final RequestType reqType = (RequestType)Mockito.mock(RequestType.class);
    private final RecordingChannel channel = new RecordingChannel();

    @Test
    public void shouldSendExceptionBackToClientOnInvalidChecksum() throws Throwable {
        Server<Object, Object> server = this.newServer(this.checksumVerifier);
        RequestContext ctx = new RequestContext(0L, 1, 0, 2L, 12L);
        ((TxChecksumVerifier)Mockito.doThrow((Throwable)new IllegalStateException("123")).when((Object)this.checksumVerifier)).assertMatch(Matchers.anyLong(), Matchers.anyLong());
        try {
            server.messageReceived(this.channelCtx(this.channel), this.message(this.reqType, ctx, this.channel, Protocol.EMPTY_SERIALIZER));
            TestCase.fail((String)"Should have failed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.protocol.deserializeResponse(this.channel.asBlockingReadHandler(), ByteBuffer.allocateDirect(1024), 1L, Protocol.VOID_DESERIALIZER, (ResourceReleaser)Mockito.mock(ResourceReleaser.class), (LogEntryReader)new VersionAwareLogEntryReader());
            TestCase.fail((String)"Should have failed.");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"123"));
        }
    }

    @Test
    public void shouldNotSendExceptionBackToClientOnInvalidChecksumIfThereAreNoTransactions() throws Throwable {
        Server<Object, Object> server = this.newServer(this.checksumVerifier);
        RequestContext ctx = new RequestContext(0L, 1, 0, 1L, 0L);
        server.messageReceived(this.channelCtx(this.channel), this.message(this.reqType, ctx, this.channel, Protocol.EMPTY_SERIALIZER));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.checksumVerifier});
    }

    private MessageEvent message(RequestType reqType, RequestContext ctx, Channel serverToClientChannel, Serializer payloadSerializer) throws IOException {
        ByteBuffer backingBuffer = ByteBuffer.allocate(1024);
        this.protocol.serializeRequest((Channel)new RecordingChannel(), (ChannelBuffer)new ByteBufferBackedChannelBuffer(backingBuffer), reqType, ctx, payloadSerializer);
        MessageEvent event = (MessageEvent)Mockito.mock(MessageEvent.class);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)new ByteBufferBackedChannelBuffer(backingBuffer));
        Mockito.when((Object)event.getChannel()).thenReturn((Object)serverToClientChannel);
        return event;
    }

    private ChannelHandlerContext channelCtx(Channel channel) {
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.getChannel()).thenReturn((Object)channel);
        return ctx;
    }

    private Server<Object, Object> newServer(TxChecksumVerifier checksumVerifier) throws Throwable {
        Server.Configuration conf = (Server.Configuration)Mockito.mock(Server.Configuration.class);
        Mockito.when((Object)conf.getServerAddress()).thenReturn((Object)new HostnamePort("aa", -1667));
        Server<Object, Object> server = new Server<Object, Object>(null, conf, (LogProvider)NullLogProvider.getInstance(), 0x1000000, new ProtocolVersion(0, 2), checksumVerifier, Clocks.systemClock(), (ByteCounterMonitor)Mockito.mock(ByteCounterMonitor.class), (RequestMonitor)Mockito.mock(RequestMonitor.class)){

            protected RequestType<Object> getRequestContext(byte id) {
                return (RequestType)Mockito.mock(RequestType.class);
            }

            protected void stopConversation(RequestContext context) {
            }
        };
        server.init();
        return server;
    }
}

