/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ResponsePackerIT {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void shouldPackTheHighestTxCommittedAsObligation() throws Exception {
        LogicalTransactionStore transactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        try (NeoStores neoStore = this.createNeoStore((FileSystemAbstraction)fs, pageCache);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.transactionCommitted(2L, 111L, 0L);
            store.transactionCommitted(3L, 222L, 0L);
            store.transactionCommitted(4L, 333L, 0L);
            store.transactionCommitted(5L, 444L, 0L);
            store.transactionCommitted(6L, 555L, 0L);
            long expectedTxId = 8L;
            store.transactionCommitted(8L, 777L, 0L);
            ResponsePacker packer = new ResponsePacker(transactionStore, (TransactionIdStore)store, Suppliers.singleton((Object)StoreIdTestFactory.newStoreIdForCurrentVersion()));
            Response response = packer.packTransactionObligationResponse(new RequestContext(0L, 0, 0, 0L, 0L), new Object());
            Assert.assertTrue((boolean)(response instanceof TransactionObligationResponse));
            ((TransactionObligationResponse)response).accept(new Response.Handler(){

                public void obligation(long txId) throws IOException {
                    Assert.assertEquals((long)8L, (long)txId);
                }

                public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
                    throw new UnsupportedOperationException("not expected");
                }
            });
        }
    }

    private NeoStores createNeoStore(FileSystemAbstraction fs, PageCache pageCache) throws IOException {
        File storeDir = new File("/store/");
        fs.mkdirs(storeDir);
        StoreFactory storeFactory = new StoreFactory(storeDir, pageCache, fs, (LogProvider)NullLogProvider.getInstance());
        return storeFactory.openAllNeoStores(true);
    }
}

