/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class StoreCopyClientTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final CleanupRule cleanup = new CleanupRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public TestRule rules = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.cleanup);
    private FileSystemAbstraction fileSystem;

    @Before
    public void setUp() {
        this.fileSystem = this.fileSystemRule.get();
    }

    @Test
    public void shouldCopyStoreFilesAcrossIfACancellationRequestHappensAfterTheTempStoreHasBeenRecovered() throws Exception {
        File copyDir = new File(this.testDir.directory(), "copy");
        File originalDir = new File(this.testDir.directory(), "original");
        final AtomicBoolean cancelStoreCopy = new AtomicBoolean(false);
        StoreCopyClient.Monitor.Adapter storeCopyMonitor = new StoreCopyClient.Monitor.Adapter(){

            public void finishRecoveringStore() {
                cancelStoreCopy.set(true);
            }
        };
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        StoreCopyClient copier = new StoreCopyClient(copyDir, Config.empty(), StoreCopyClientTest.loadKernelExtensions(), (LogProvider)NullLogProvider.getInstance(), this.fileSystem, pageCache, (StoreCopyClient.Monitor)storeCopyMonitor, false);
        GraphDatabaseAPI original = (GraphDatabaseAPI)this.startDatabase(originalDir);
        try (Transaction tx = original.beginTx();){
            original.createNode(new Label[]{Label.label((String)"BeforeCopyBegins")});
            tx.success();
        }
        StoreCopyClient.StoreCopyRequester storeCopyRequest = (StoreCopyClient.StoreCopyRequester)Mockito.spy((Object)new LocalStoreCopyRequester(original, originalDir, this.fileSystem));
        copier.copyStore(storeCopyRequest, cancelStoreCopy::get, MoveAfterCopy.moveReplaceExisting());
        GraphDatabaseService copy = this.startDatabase(copyDir);
        try (Transaction tx = copy.beginTx();){
            long nodesCount = Iterators.count((Iterator)copy.findNodes(Label.label((String)"BeforeCopyBegins")));
            Assert.assertThat((Object)nodesCount, (Matcher)Matchers.equalTo((Object)1L));
            Assert.assertThat((Object)((Node)Iterators.single((Iterator)copy.findNodes(Label.label((String)"BeforeCopyBegins")))).getId(), (Matcher)Matchers.equalTo((Object)0L));
            tx.success();
        }
        ((StoreCopyClient.StoreCopyRequester)Mockito.verify((Object)storeCopyRequest, (VerificationMode)Mockito.times((int)1))).done();
        Assert.assertFalse((boolean)new File(copyDir, "temp-copy").exists());
    }

    @Test
    public void storeCopyClientMustWorkWithStandardRecordFormat() throws Exception {
        this.checkStoreCopyClientWithRecordFormats("standard");
    }

    @Test
    public void storeCopyClientMustWorkWithHighLimitRecordFormat() throws Exception {
        this.checkStoreCopyClientWithRecordFormats("high_limit");
    }

    private void checkStoreCopyClientWithRecordFormats(String recordFormatsName) throws Exception {
        File copyDir = new File(this.testDir.directory(), "copy");
        File originalDir = new File(this.testDir.directory(), "original");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        Config config = Config.empty().augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.record_format.name(), recordFormatsName}));
        StoreCopyClient copier = new StoreCopyClient(copyDir, config, StoreCopyClientTest.loadKernelExtensions(), (LogProvider)NullLogProvider.getInstance(), this.fileSystem, pageCache, (StoreCopyClient.Monitor)new StoreCopyClient.Monitor.Adapter(), false);
        GraphDatabaseAPI original = (GraphDatabaseAPI)this.startDatabase(originalDir, recordFormatsName);
        LocalStoreCopyRequester storeCopyRequest = new LocalStoreCopyRequester(original, originalDir, this.fileSystem);
        copier.copyStore((StoreCopyClient.StoreCopyRequester)storeCopyRequest, CancellationRequest.NEVER_CANCELLED, MoveAfterCopy.moveReplaceExisting());
        Assert.assertFalse((boolean)new File(copyDir, "temp-copy").exists());
        this.startDatabase(copyDir, recordFormatsName).shutdown();
    }

    @Test
    public void shouldEndUpWithAnEmptyStoreIfCancellationRequestIssuedJustBeforeRecoveryTakesPlace() throws Exception {
        File copyDir = new File(this.testDir.directory(), "copy");
        File originalDir = new File(this.testDir.directory(), "original");
        final AtomicBoolean cancelStoreCopy = new AtomicBoolean(false);
        StoreCopyClient.Monitor.Adapter storeCopyMonitor = new StoreCopyClient.Monitor.Adapter(){

            public void finishReceivingStoreFiles() {
                cancelStoreCopy.set(true);
            }
        };
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        StoreCopyClient copier = new StoreCopyClient(copyDir, Config.empty(), StoreCopyClientTest.loadKernelExtensions(), (LogProvider)NullLogProvider.getInstance(), this.fileSystem, pageCache, (StoreCopyClient.Monitor)storeCopyMonitor, false);
        GraphDatabaseAPI original = (GraphDatabaseAPI)this.startDatabase(originalDir);
        try (Transaction tx = original.beginTx();){
            original.createNode(new Label[]{Label.label((String)"BeforeCopyBegins")});
            tx.success();
        }
        StoreCopyClient.StoreCopyRequester storeCopyRequest = (StoreCopyClient.StoreCopyRequester)Mockito.spy((Object)new LocalStoreCopyRequester(original, originalDir, this.fileSystem));
        copier.copyStore(storeCopyRequest, cancelStoreCopy::get, MoveAfterCopy.moveReplaceExisting());
        GraphDatabaseService copy = this.startDatabase(copyDir);
        try (Transaction tx = copy.beginTx();){
            long nodesCount = Iterators.count((Iterator)copy.findNodes(Label.label((String)"BeforeCopyBegins")));
            Assert.assertThat((Object)nodesCount, (Matcher)Matchers.equalTo((Object)0L));
            tx.success();
        }
        ((StoreCopyClient.StoreCopyRequester)Mockito.verify((Object)storeCopyRequest, (VerificationMode)Mockito.times((int)1))).done();
        Assert.assertFalse((boolean)new File(copyDir, "temp-copy").exists());
    }

    @Test
    public void shouldResetNeoStoreLastTransactionOffsetForNonForensicCopy() throws Exception {
        File initialStore = this.testDir.directory("initialStore");
        File backupStore = this.testDir.directory("backupStore");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        this.createInitialDatabase(initialStore);
        long originalTransactionOffset = MetaDataStore.getRecord((PageCache)pageCache, (File)new File(initialStore, "neostore"), (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        GraphDatabaseService initialDatabase = this.startDatabase(initialStore);
        StoreCopyClient copier = new StoreCopyClient(backupStore, Config.empty(), StoreCopyClientTest.loadKernelExtensions(), (LogProvider)NullLogProvider.getInstance(), this.fileSystem, pageCache, (StoreCopyClient.Monitor)new StoreCopyClient.Monitor.Adapter(), false);
        CancellationRequest falseCancellationRequest = () -> false;
        LocalStoreCopyRequester storeCopyRequest = new LocalStoreCopyRequester((GraphDatabaseAPI)initialDatabase, initialStore, this.fileSystem);
        copier.copyStore((StoreCopyClient.StoreCopyRequester)storeCopyRequest, falseCancellationRequest, MoveAfterCopy.moveReplaceExisting());
        long updatedTransactionOffset = MetaDataStore.getRecord((PageCache)pageCache, (File)new File(backupStore, "neostore"), (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        Assert.assertNotEquals((long)originalTransactionOffset, (long)updatedTransactionOffset);
        Assert.assertEquals((long)16L, (long)updatedTransactionOffset);
        Assert.assertFalse((boolean)new File(backupStore, "temp-copy").exists());
    }

    @Test
    public void shouldDeleteTempCopyFolderOnFailures() throws Exception {
        File initialStore = this.testDir.directory("initialStore");
        File backupStore = this.testDir.directory("backupStore");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        GraphDatabaseService initialDatabase = this.createInitialDatabase(initialStore);
        StoreCopyClient copier = new StoreCopyClient(backupStore, Config.empty(), StoreCopyClientTest.loadKernelExtensions(), (LogProvider)NullLogProvider.getInstance(), this.fileSystem, pageCache, (StoreCopyClient.Monitor)new StoreCopyClient.Monitor.Adapter(), false);
        CancellationRequest falseCancellationRequest = () -> false;
        final RuntimeException exception = new RuntimeException("Boom!");
        LocalStoreCopyRequester storeCopyRequest = new LocalStoreCopyRequester((GraphDatabaseAPI)initialDatabase, initialStore, this.fileSystem){

            @Override
            public void done() {
                throw exception;
            }
        };
        try {
            copier.copyStore((StoreCopyClient.StoreCopyRequester)storeCopyRequest, falseCancellationRequest, MoveAfterCopy.moveReplaceExisting());
            Assert.fail((String)"should have thrown ");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)exception, (Object)ex);
        }
        Assert.assertFalse((boolean)new File(backupStore, "temp-copy").exists());
    }

    private GraphDatabaseService createInitialDatabase(File initialStore) {
        GraphDatabaseService initialDatabase = this.startDatabase(initialStore);
        for (int i = 0; i < 10; ++i) {
            try (Transaction tx = initialDatabase.beginTx();){
                initialDatabase.createNode(new Label[]{Label.label((String)("Neo" + i))});
                tx.success();
                continue;
            }
        }
        initialDatabase.shutdown();
        return initialDatabase;
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return this.startDatabase(storeDir, "standard");
    }

    private GraphDatabaseService startDatabase(File storeDir, String recordFormatName) {
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.record_format, recordFormatName).newGraphDatabase();
        return (GraphDatabaseService)this.cleanup.add((Object)database);
    }

    private static List<KernelExtensionFactory<?>> loadKernelExtensions() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return kernelExtensions;
    }

    private static class LocalStoreCopyRequester
    implements StoreCopyClient.StoreCopyRequester {
        private final GraphDatabaseAPI original;
        private final File originalDir;
        private final FileSystemAbstraction fs;
        private Response<?> response;

        LocalStoreCopyRequester(GraphDatabaseAPI original, File originalDir, FileSystemAbstraction fs) {
            this.original = original;
            this.originalDir = originalDir;
            this.fs = fs;
        }

        public Response<?> copyStore(StoreWriter writer) {
            NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)this.original.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
            TransactionIdStore transactionIdStore = (TransactionIdStore)this.original.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)this.original.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
            CheckPointer checkPointer = (CheckPointer)this.original.getDependencyResolver().resolveDependency(CheckPointer.class);
            PageCache pageCache = (PageCache)this.original.getDependencyResolver().resolveDependency(PageCache.class);
            RequestContext requestContext = new StoreCopyServer(neoStoreDataSource, checkPointer, this.fs, this.originalDir, (StoreCopyServer.Monitor)new Monitors().newMonitor(StoreCopyServer.Monitor.class, new String[0]), pageCache, new StoreCopyCheckPointMutex()).flushStoresAndStreamStoreFiles("test", writer, false);
            StoreId storeId = ((RecordStorageEngine)this.original.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getMetaDataStore().getStoreId();
            ResponsePacker responsePacker = new ResponsePacker(logicalTransactionStore, transactionIdStore, () -> storeId);
            this.response = (Response)Mockito.spy((Object)responsePacker.packTransactionStreamResponse(requestContext, null));
            return this.response;
        }

        public void done() {
            Assert.assertNotNull(this.response);
            ((Response)Mockito.verify(this.response, (VerificationMode)Mockito.times((int)1))).close();
        }
    }
}

