/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.util.Collections;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.storecopy.TransactionBatchCommitter;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TestKernelTransactionHandle;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionBatchCommitterTest {
    private final KernelTransactions kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);
    private final TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldCommitSmallBatch() throws Exception {
        long safeZone = 10L;
        TransactionBatchCommitter committer = this.newBatchCommitter(safeZone);
        TransactionChain chain = this.createTxChain(3, 1L, 1L);
        committer.apply(chain.first, chain.last);
        ((TransactionCommitProcess)Mockito.verify((Object)this.commitProcess)).commit((TransactionToApply)Matchers.eq((Object)chain.first), (CommitEvent)Matchers.any(), (TransactionApplicationMode)Matchers.eq((Object)TransactionApplicationMode.EXTERNAL));
    }

    @Test
    public void shouldCommitLargeBatch() throws Exception {
        long safeZone = 10L;
        TransactionBatchCommitter committer = this.newBatchCommitter(safeZone);
        TransactionChain chain = this.createTxChain(100, 1L, 10L);
        committer.apply(chain.first, chain.last);
        ((TransactionCommitProcess)Mockito.verify((Object)this.commitProcess)).commit((TransactionToApply)Matchers.eq((Object)chain.first), (CommitEvent)Matchers.any(), (TransactionApplicationMode)Matchers.eq((Object)TransactionApplicationMode.EXTERNAL));
    }

    @Test
    public void shouldNotBlockTransactionsForSmallBatch() throws Exception {
        long safeZone = 10L;
        TransactionBatchCommitter committer = this.newBatchCommitter(safeZone);
        TransactionChain chain = this.createTxChain(3, 1L, 1L);
        committer.apply(chain.first, chain.last);
        ((KernelTransactions)Mockito.verify((Object)this.kernelTransactions, (VerificationMode)Mockito.never())).blockNewTransactions();
        ((KernelTransactions)Mockito.verify((Object)this.kernelTransactions, (VerificationMode)Mockito.never())).unblockNewTransactions();
    }

    @Test
    public void shouldBlockTransactionsForLargeBatch() throws Exception {
        long safeZone = 10L;
        TransactionBatchCommitter committer = this.newBatchCommitter(safeZone);
        TransactionChain chain = this.createTxChain(100, 1L, 10L);
        committer.apply(chain.first, chain.last);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.kernelTransactions});
        ((KernelTransactions)inOrder.verify((Object)this.kernelTransactions)).blockNewTransactions();
        ((KernelTransactions)inOrder.verify((Object)this.kernelTransactions)).unblockNewTransactions();
    }

    @Test
    public void shouldTerminateOutdatedTransactions() throws Exception {
        long safeZone = 10L;
        int txCount = 3;
        long firstCommitTimestamp = 10L;
        long commitTimestampInterval = 2L;
        TransactionBatchCommitter committer = this.newBatchCommitter(safeZone);
        TransactionChain chain = this.createTxChain(txCount, firstCommitTimestamp, commitTimestampInterval);
        long timestampOutsideSafeZone = chain.last.transactionRepresentation().getLatestCommittedTxWhenStarted() - safeZone - 1L;
        KernelTransaction txToTerminate = this.newKernelTransaction(timestampOutsideSafeZone);
        KernelTransaction tx = this.newKernelTransaction(firstCommitTimestamp - 1L);
        Mockito.when((Object)this.kernelTransactions.activeTransactions()).thenReturn((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{this.newHandle(txToTerminate), this.newHandle(tx)}));
        committer.apply(chain.first, chain.last);
        ((KernelTransaction)Mockito.verify((Object)txToTerminate)).markForTermination((Status)Status.Transaction.Outdated);
        ((KernelTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).markForTermination((Status)Matchers.any());
        this.logProvider.assertContainsLogCallContaining("Marking transaction for termination");
        this.logProvider.assertContainsLogCallContaining("lastCommittedTxId:" + (1L + (long)txCount - 1L));
    }

    private KernelTransactionHandle newHandle(KernelTransaction tx) {
        return new TestKernelTransactionHandle(tx);
    }

    private KernelTransaction newKernelTransaction(long lastTransactionTimestampWhenStarted) {
        KernelTransaction txToTerminate = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)txToTerminate.lastTransactionTimestampWhenStarted()).thenReturn((Object)lastTransactionTimestampWhenStarted);
        return txToTerminate;
    }

    private TransactionBatchCommitter newBatchCommitter(long safeZone) {
        return new TransactionBatchCommitter(this.kernelTransactions, safeZone, this.commitProcess, this.logProvider.getLog(TransactionBatchCommitter.class));
    }

    private TransactionChain createTxChain(int txCount, long firstCommitTimestamp, long commitTimestampInterval) {
        TransactionToApply first = null;
        TransactionToApply last = null;
        long commitTimestamp = firstCommitTimestamp;
        for (long i = 1L; i < 1L + (long)txCount; ++i) {
            TransactionToApply tx = this.tx(i, commitTimestamp);
            if (first == null) {
                first = tx;
                last = tx;
            } else {
                last.next(tx);
                last = tx;
            }
            commitTimestamp += commitTimestampInterval;
        }
        return new TransactionChain(first, last);
    }

    private TransactionToApply tx(long id, long commitTimestamp) {
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
        representation.setHeader(new byte[0], 0, 0, commitTimestamp - 10L, id - 1L, commitTimestamp, 0);
        return new TransactionToApply((TransactionRepresentation)representation, id);
    }

    private class TransactionChain {
        final TransactionToApply first;
        final TransactionToApply last;

        private TransactionChain(TransactionToApply first, TransactionToApply last) {
            this.first = first;
            this.last = last;
        }
    }
}

