/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.commandline.arguments.common.Database;
import org.neo4j.helpers.Args;

public class DatabaseTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Database arg = new Database();

    @Test
    public void parseDatabaseShouldThrowOnPath() throws Exception {
        Path path = Paths.get("data", "databases", "graph.db");
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("'database' should be a name but you seem to have specified a path: " + path);
        this.arg.parse(Args.parse((String[])new String[]{"--database=" + path}));
    }

    @Test
    public void parseDatabaseName() throws Exception {
        Assert.assertEquals((Object)"bob.db", (Object)this.arg.parse(Args.parse((String[])new String[]{"--database=bob.db"})));
    }
}

