/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;

public class AdminCommandSectionTest {
    @Mock
    private Consumer<String> out;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void shouldPrintUsageForAllCommandsAlphabetically() {
        AdminCommandSection generalSection = AdminCommandSection.general();
        List<AdminCommand.Provider> providers = Arrays.asList(this.mockCommand("restore", "Restore"), this.mockCommand("bam", "A summary"), this.mockCommand("zzzz-last-one", "Another summary"));
        generalSection.printAllCommandsUnderSection(this.out, providers);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("General");
        ((Consumer)ordered.verify(this.out)).accept("    bam");
        ((Consumer)ordered.verify(this.out)).accept("        A summary");
        ((Consumer)ordered.verify(this.out)).accept("    restore");
        ((Consumer)ordered.verify(this.out)).accept("        Restore");
        ((Consumer)ordered.verify(this.out)).accept("    zzzz-last-one");
        ((Consumer)ordered.verify(this.out)).accept("        Another summary");
        ordered.verifyNoMoreInteractions();
    }

    @Test
    public void equalsUsingReflection() throws Exception {
        Assert.assertTrue((boolean)AdminCommandSection.general().equals((Object)new TestGeneralSection()));
        Assert.assertFalse((boolean)AdminCommandSection.general().equals((Object)new TestAnotherGeneralSection()));
    }

    @Test
    public void hashCodeUsingReflection() throws Exception {
        TestGeneralSection testGeneralSection = new TestGeneralSection();
        TestAnotherGeneralSection testAnotherGeneralSection = new TestAnotherGeneralSection();
        HashMap<AdminCommandSection, String> map = new HashMap<AdminCommandSection, String>();
        map.put(AdminCommandSection.general(), "General-Original");
        map.put(testGeneralSection, "General-Test");
        map.put(testAnotherGeneralSection, "General-AnotherTest");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"General-Test", map.get(AdminCommandSection.general()));
        Assert.assertEquals((Object)"General-Test", map.get((Object)testGeneralSection));
        Assert.assertEquals((Object)"General-AnotherTest", map.get((Object)testAnotherGeneralSection));
    }

    private AdminCommand.Provider mockCommand(String name, String summary) {
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)name);
        Mockito.when((Object)commandProvider.summary()).thenReturn((Object)summary);
        Mockito.when((Object)commandProvider.commandSection()).thenReturn((Object)AdminCommandSection.general());
        return commandProvider;
    }

    private class TestAnotherGeneralSection
    extends AdminCommandSection {
        private TestAnotherGeneralSection() {
        }

        @Nonnull
        public String printable() {
            return "Another Section";
        }
    }

    private class TestGeneralSection
    extends AdminCommandSection {
        private TestGeneralSection() {
        }

        @Nonnull
        public String printable() {
            return "General";
        }
    }
}

