/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.CannedLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.arguments.Arguments;

public class UsageTest {
    @Mock
    private Consumer<String> out;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void shouldPrintUsageForACommand() {
        AdminCommand.Provider commandProvider = this.mockCommand("bam", "A summary", AdminCommandSection.general());
        AdminCommand.Provider[] commands = new AdminCommand.Provider[]{commandProvider};
        Usage usage = new Usage("neo4j-admin", (CommandLocator)new CannedLocator(commands));
        usage.printUsageForCommand(commandProvider, this.out);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("usage: neo4j-admin bam ");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("environment variables:");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_CONF    Path to directory which contains neo4j.conf.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_DEBUG   Set to anything to enable debug output.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_HOME    Neo4j home directory.");
        ((Consumer)ordered.verify(this.out)).accept("    HEAP_SIZE     Set JVM maximum heap size during command execution.");
        ((Consumer)ordered.verify(this.out)).accept("                  Takes a number and a unit, for example 512m.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("description");
    }

    @Test
    public void shouldPrintUsageWithConfiguration() {
        AdminCommand.Provider[] commands = new AdminCommand.Provider[]{this.mockCommand("bam", "A summary", AdminCommandSection.general())};
        Usage usage = new Usage("neo4j-admin", (CommandLocator)new CannedLocator(commands));
        usage.print(this.out);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("usage: neo4j-admin <command>");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("Manage your Neo4j instance.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("environment variables:");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_CONF    Path to directory which contains neo4j.conf.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_DEBUG   Set to anything to enable debug output.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_HOME    Neo4j home directory.");
        ((Consumer)ordered.verify(this.out)).accept("    HEAP_SIZE     Set JVM maximum heap size during command execution.");
        ((Consumer)ordered.verify(this.out)).accept("                  Takes a number and a unit, for example 512m.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("available commands:");
        ((Consumer)ordered.verify(this.out)).accept("General");
        ((Consumer)ordered.verify(this.out)).accept("    bam");
        ((Consumer)ordered.verify(this.out)).accept("        A summary");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("Use neo4j-admin help <command> for more details.");
        ordered.verifyNoMoreInteractions();
    }

    @Test
    public void commandsUnderSameAdminCommandSectionPrintableSectionShouldAppearTogether() {
        AdminCommand.Provider[] commands = new AdminCommand.Provider[]{this.mockCommand("first-command", "first-command", AdminCommandSection.general()), this.mockCommand("second-command", "second-command", new TestGeneralSection())};
        Usage usage = new Usage("neo4j-admin", (CommandLocator)new CannedLocator(commands));
        usage.print(this.out);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("usage: neo4j-admin <command>");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("Manage your Neo4j instance.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("environment variables:");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_CONF    Path to directory which contains neo4j.conf.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_DEBUG   Set to anything to enable debug output.");
        ((Consumer)ordered.verify(this.out)).accept("    NEO4J_HOME    Neo4j home directory.");
        ((Consumer)ordered.verify(this.out)).accept("    HEAP_SIZE     Set JVM maximum heap size during command execution.");
        ((Consumer)ordered.verify(this.out)).accept("                  Takes a number and a unit, for example 512m.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("available commands:");
        ((Consumer)ordered.verify(this.out)).accept("General");
        ((Consumer)ordered.verify(this.out)).accept("    first-command");
        ((Consumer)ordered.verify(this.out)).accept("        first-command");
        ((Consumer)ordered.verify(this.out)).accept("    second-command");
        ((Consumer)ordered.verify(this.out)).accept("        second-command");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("Use neo4j-admin help <command> for more details.");
        ordered.verifyNoMoreInteractions();
    }

    private AdminCommand.Provider mockCommand(String name, String summary, AdminCommandSection section) {
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)name);
        Mockito.when((Object)commandProvider.summary()).thenReturn((Object)summary);
        Mockito.when((Object)commandProvider.allArguments()).thenReturn((Object)Arguments.NO_ARGS);
        Mockito.when((Object)commandProvider.possibleArguments()).thenReturn(Collections.singletonList(Arguments.NO_ARGS));
        Mockito.when((Object)commandProvider.description()).thenReturn((Object)"description");
        Mockito.when((Object)commandProvider.commandSection()).thenReturn((Object)section);
        return commandProvider;
    }

    private static class TestGeneralSection
    extends AdminCommandSection {
        private TestGeneralSection() {
        }

        @Nonnull
        public String printable() {
            return "General";
        }
    }
}

