/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;

public class ArgumentsTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Arguments builder;

    @Before
    public void setup() {
        this.builder = new Arguments();
    }

    @Test
    public void throwsOnUnexpectedLongArgument() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized option: 'stacktrace'");
        this.builder.withDatabase().parse(new String[]{"--stacktrace"});
    }

    @Test
    public void throwsOnUnexpectedLongArgumentWithValue() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized option: 'stacktrace'");
        this.builder.withDatabase().parse(new String[]{"--stacktrace=true"});
    }

    @Test
    public void throwsOnUnexpectedShortArgument() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized option: 'f'");
        this.builder.withDatabase().parse(new String[]{"-f"});
    }

    @Test
    public void throwsOnUnexpectedShortArgumentWithValue() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized option: 'f'");
        this.builder.withDatabase().parse(new String[]{"-f=bob"});
    }

    @Test
    public void throwsOnUnexpectedPositionalArgument() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized arguments: 'bob sob'");
        this.builder.withDatabase().parse(new String[]{"bob", "sob"});
    }

    @Test
    public void throwsOnUnexpectedPositionalArgumentWhenExpectingSome() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("unrecognized arguments: 'three four'");
        this.builder.withMandatoryPositionalArgument(0, "first").withOptionalPositionalArgument(1, "second").parse(new String[]{"one", "two", "three", "four"});
    }

    @Test
    public void throwsOnTooFewPositionalArguments() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("not enough arguments");
        this.builder.withMandatoryPositionalArgument(0, "first").withOptionalPositionalArgument(1, "second").parse(new String[0]);
    }

    @Test
    public void argumentNoValue() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag"});
        Assert.assertEquals((Object)true, (Object)args.getBoolean("flag"));
        args.parse(new String[0]);
        Assert.assertEquals((Object)false, (Object)args.getBoolean("flag"));
    }

    @Test
    public void argumentWithEquals() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag=true"});
        Assert.assertEquals((Object)true, (Object)args.getBoolean("flag"));
        args.parse(new String[]{"--flag=false"});
        Assert.assertEquals((Object)false, (Object)args.getBoolean("flag"));
    }

    @Test
    public void argumentWithSpace() throws Exception {
        Arguments args = this.builder.withArgument((NamedArgument)new OptionalBooleanArg("flag", false, "description"));
        args.parse(new String[]{"--flag", "true"});
        Assert.assertEquals((Object)true, (Object)args.getBoolean("flag"));
        args.parse(new String[]{"--flag", "false"});
        Assert.assertEquals((Object)false, (Object)args.getBoolean("flag"));
    }

    @Test
    public void withDatabaseUsage() {
        Assert.assertEquals((Object)"[--database=<name>]", (Object)this.builder.withDatabase().usage());
    }

    @Test
    public void withDatabaseDescription() {
        Assert.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>   Name of database. [default:graph.db]", new Object[0]), (Object)this.builder.withDatabase().description("How to use"));
    }

    @Test
    public void withDatabaseToUsage() {
        Assert.assertEquals((Object)"[--database=<name>] --to=<destination-path>", (Object)this.builder.withDatabase().withTo("Destination file.").usage());
    }

    @Test
    public void withDatabaseToDescription() {
        Assert.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>         Name of database. [default:graph.db]%n  --to=<destination-path>   Destination file.", new Object[0]), (Object)this.builder.withDatabase().withTo("Destination file.").description("How to use"));
    }

    @Test
    public void withDatabaseToMultilineDescription() {
        Assert.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>         Name of database. [default:graph.db]%n  --to=<destination-path>   This is a long string which should wrap on right%n                            col.", new Object[0]), (Object)this.builder.withDatabase().withTo("This is a long string which should wrap on right col.").description("How to use"));
    }

    @Test
    public void longNamesTriggerNewLineFormatting() {
        Assert.assertEquals((Object)String.format("How to use%n%noptions:%n  --database=<name>%n      Name of database. [default:graph.db]%n  --to=<destination-path>%n      This is a long string which should not wrap on right col.%n  --loooooooooooooong-variable-name=<loooooooooooooong-variable-value>%n      This is also a long string which should be printed on a new line because%n      of long names.", new Object[0]), (Object)this.builder.withDatabase().withTo("This is a long string which should not wrap on right col.").withArgument((NamedArgument)new MandatoryNamedArg("loooooooooooooong-variable-name", "loooooooooooooong-variable-value", "This is also a long string which should be printed on a new line because of long names.")).description("How to use"));
    }

    @Test
    public void descriptionShouldHandleExistingNewlines() {
        Assert.assertEquals((Object)String.format("This is the first line%nAnd this is the second line%nThe third line is so long that it requires some wrapping by the code itself%nbecause as you can see it just keeps going ang going and going and going and%ngoing and going.", new Object[0]), (Object)this.builder.description(String.format("This is the first line%nAnd this is the second line%nThe third line is so long that it requires some wrapping by the code itself because as you can see it just keeps going ang going and going and going and going and going.", new Object[0])));
    }

    @Test
    public void wrappingHandlesBothKindsOfLineEndingsAndOutputsPlatformDependentOnes() {
        Assert.assertEquals((Object)String.format("One with Linux%nOne with Windows%nAnd one which is%njust long and should%nbe wrapped by the%nfunction", new Object[0]), (Object)Arguments.wrapText((String)"One with Linux\nOne with Windows\r\nAnd one which is just long and should be wrapped by the function", (int)20));
    }
}

