/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;

class AdminCommandSectionTest {
    @Mock
    private Consumer<String> out;

    AdminCommandSectionTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    void shouldPrintUsageForAllCommandsAlphabetically() {
        AdminCommandSection generalSection = AdminCommandSection.general();
        List<AdminCommand.Provider> providers = Arrays.asList(AdminCommandSectionTest.mockCommand("restore", "Restore"), AdminCommandSectionTest.mockCommand("bam", "A summary"), AdminCommandSectionTest.mockCommand("zzzz-last-one", "Another summary"));
        generalSection.printAllCommandsUnderSection(this.out, providers);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("General");
        ((Consumer)ordered.verify(this.out)).accept("    bam");
        ((Consumer)ordered.verify(this.out)).accept("        A summary");
        ((Consumer)ordered.verify(this.out)).accept("    restore");
        ((Consumer)ordered.verify(this.out)).accept("        Restore");
        ((Consumer)ordered.verify(this.out)).accept("    zzzz-last-one");
        ((Consumer)ordered.verify(this.out)).accept("        Another summary");
        ordered.verifyNoMoreInteractions();
    }

    @Test
    void equalsUsingReflection() {
        Assertions.assertEquals((Object)AdminCommandSection.general(), (Object)((Object)new TestGeneralSection()));
        Assertions.assertNotEquals((Object)AdminCommandSection.general(), (Object)((Object)new TestAnotherGeneralSection()));
    }

    @Test
    void hashCodeUsingReflection() {
        TestGeneralSection testGeneralSection = new TestGeneralSection();
        TestAnotherGeneralSection testAnotherGeneralSection = new TestAnotherGeneralSection();
        HashMap<AdminCommandSection, String> map = new HashMap<AdminCommandSection, String>();
        map.put(AdminCommandSection.general(), "General-Original");
        map.put(testGeneralSection, "General-Test");
        map.put(testAnotherGeneralSection, "General-AnotherTest");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"General-Test", map.get(AdminCommandSection.general()));
        Assertions.assertEquals((Object)"General-Test", map.get((Object)testGeneralSection));
        Assertions.assertEquals((Object)"General-AnotherTest", map.get((Object)testAnotherGeneralSection));
    }

    private static AdminCommand.Provider mockCommand(String name, String summary) {
        AdminCommand.Provider commandProvider = (AdminCommand.Provider)Mockito.mock(AdminCommand.Provider.class);
        Mockito.when((Object)commandProvider.name()).thenReturn((Object)name);
        Mockito.when((Object)commandProvider.summary()).thenReturn((Object)summary);
        Mockito.when((Object)commandProvider.commandSection()).thenReturn((Object)AdminCommandSection.general());
        return commandProvider;
    }

    private static class TestAnotherGeneralSection
    extends AdminCommandSection {
        private TestAnotherGeneralSection() {
        }

        @Nonnull
        public String printable() {
            return "Another Section";
        }
    }

    private static class TestGeneralSection
    extends AdminCommandSection {
        private TestGeneralSection() {
        }

        @Nonnull
        public String printable() {
            return "General";
        }
    }
}

