/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CannedLocator;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.NullOutsideWorld;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.helpers.collection.Iterables;

class AdminToolTest {
    AdminToolTest() {
    }

    @Test
    void shouldExecuteTheCommand() throws CommandFailed, IncorrectUsage {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), (BlockerLocator)new NullBlockerLocator(), (OutsideWorld)new NullOutsideWorld(), false).execute(null, null, new String[]{"command", "the", "other", "args"});
        ((AdminCommand)Mockito.verify((Object)command)).execute(new String[]{"the", "other", "args"});
    }

    @Test
    void shouldExit0WhenEverythingWorks() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new CannedLocator(new NullCommandProvider()), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"null"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(0);
    }

    @Test
    void shouldAddTheHelpCommandToThoseProvidedByTheLocator() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new NullCommandLocator(), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"help"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdOutLine("    help");
    }

    @Test
    void shouldProvideFeedbackWhenNoCommandIsProvided() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new NullCommandLocator(), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[0]);
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("you must provide a command");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("usage: neo4j-admin <command>");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldProvideFeedbackIfTheCommandThrowsARuntimeException() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new RuntimeException("the-exception-message");
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("unexpected error: the-exception-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldPrintTheStacktraceWhenTheCommandThrowsARuntimeExceptionIfTheDebugFlagIsSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        RuntimeException exception = new RuntimeException("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, true).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).printStacktrace((Exception)exception);
    }

    @Test
    void shouldNotPrintTheStacktraceWhenTheCommandThrowsARuntimeExceptionIfTheDebugFlagIsNotSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        RuntimeException exception = new RuntimeException("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld, (VerificationMode)Mockito.never())).printStacktrace((Exception)exception);
    }

    @Test
    void shouldProvideFeedbackIfTheCommandFails() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new CommandFailed("the-failure-message");
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("command failed: the-failure-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldPrintTheStacktraceWhenTheCommandFailsIfTheDebugFlagIsSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CommandFailed exception = new CommandFailed("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, true).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).printStacktrace((Exception)exception);
    }

    @Test
    void shouldNotPrintTheStacktraceWhenTheCommandFailsIfTheDebugFlagIsNotSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CommandFailed exception = new CommandFailed("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld, (VerificationMode)Mockito.never())).printStacktrace((Exception)exception);
    }

    @Test
    void shouldProvideFeedbackIfTheCommandReportsAUsageProblem() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new IncorrectUsage("the-usage-message");
        };
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("exception", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"exception"});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{outsideWorld});
        ((OutsideWorld)inOrder.verify((Object)outsideWorld)).stdErrLine("the-usage-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldBlockDumpIfABlockerSaysSo() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        AdminCommand.Blocker blocker = (AdminCommand.Blocker)Mockito.mock(AdminCommand.Blocker.class);
        Mockito.when((Object)blocker.doesBlock((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)blocker.commands()).thenReturn(Collections.singleton("command"));
        Mockito.when((Object)blocker.explanation()).thenReturn((Object)"the explanation");
        BlockerLocator blockerLocator = (BlockerLocator)Mockito.mock(BlockerLocator.class);
        Mockito.when((Object)blockerLocator.findBlockers("command")).thenReturn(Collections.singletonList(blocker));
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), blockerLocator, outsideWorld, false).execute(null, null, new String[]{"command"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("command failed: the explanation");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldBlockDumpIfOneBlockerOutOfManySaysSo() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        AdminCommand.Blocker trueBlocker = (AdminCommand.Blocker)Mockito.mock(AdminCommand.Blocker.class);
        Mockito.when((Object)trueBlocker.doesBlock((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)trueBlocker.explanation()).thenReturn((Object)"trueBlocker explanation");
        AdminCommand.Blocker falseBlocker = (AdminCommand.Blocker)Mockito.mock(AdminCommand.Blocker.class);
        Mockito.when((Object)falseBlocker.doesBlock((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)falseBlocker.explanation()).thenReturn((Object)"falseBlocker explanation");
        BlockerLocator blockerLocator = (BlockerLocator)Mockito.mock(BlockerLocator.class);
        Mockito.when((Object)blockerLocator.findBlockers("command")).thenReturn(Arrays.asList(falseBlocker, trueBlocker, falseBlocker));
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), blockerLocator, outsideWorld, false).execute(null, null, new String[]{"command"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("command failed: trueBlocker explanation");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void shouldNotBlockIfNoneOfTheBlockersBlock() throws CommandFailed, IncorrectUsage {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        AdminCommand.Blocker falseBlocker = (AdminCommand.Blocker)Mockito.mock(AdminCommand.Blocker.class);
        Mockito.when((Object)falseBlocker.doesBlock((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)falseBlocker.explanation()).thenReturn((Object)"falseBlocker explanation");
        BlockerLocator blockerLocator = (BlockerLocator)Mockito.mock(BlockerLocator.class);
        Mockito.when((Object)blockerLocator.findBlockers("command")).thenReturn(Arrays.asList(falseBlocker, falseBlocker, falseBlocker));
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), blockerLocator, (OutsideWorld)new NullOutsideWorld(), false).execute(null, null, new String[]{"command", "the", "other", "args"});
        ((AdminCommand)Mockito.verify((Object)command)).execute(new String[]{"the", "other", "args"});
    }

    @Test
    void helpArgumentPrintsHelp() {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"--help"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{command});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("unrecognized command: --help");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("usage: neo4j-admin <command>");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void helpArgumentPrintsHelpForCommand() {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"command", "--help"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{command});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("unknown argument: --help");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("usage: neo4j-admin command ");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    void versionArgumentPrintsVersion() {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"--version"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{command});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdOutLine("neo4j-admin " + Util.neo4jVersion());
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(0);
    }

    @Test
    void versionArgumentPrintsVersionEvenWithCommand() {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)AdminToolTest.cannedCommand("command", command), (BlockerLocator)new NullBlockerLocator(), outsideWorld, false).execute(null, null, new String[]{"command", "--version"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{command});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdOutLine("neo4j-admin " + Util.neo4jVersion());
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(0);
    }

    private static CannedLocator cannedCommand(String name, final AdminCommand command) {
        return new CannedLocator(new AdminCommand.Provider(name, new String[0]){

            @Nonnull
            public Arguments allArguments() {
                return Arguments.NO_ARGS;
            }

            @Nonnull
            public String description() {
                return "";
            }

            @Nonnull
            public String summary() {
                return "";
            }

            @Nonnull
            public AdminCommandSection commandSection() {
                return AdminCommandSection.general();
            }

            @Nonnull
            public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
                return command;
            }
        });
    }

    private static class NullBlockerLocator
    implements BlockerLocator {
        private NullBlockerLocator() {
        }

        public Iterable<AdminCommand.Blocker> findBlockers(String name) throws NoSuchElementException {
            return Collections.emptyList();
        }
    }

    private static class NullCommandProvider
    extends AdminCommand.Provider {
        NullCommandProvider() {
            super("null", new String[0]);
        }

        public Arguments allArguments() {
            return Arguments.NO_ARGS;
        }

        public String description() {
            return "";
        }

        public String summary() {
            return "";
        }

        public AdminCommandSection commandSection() {
            return AdminCommandSection.general();
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return args -> {};
        }
    }

    private static class NullCommandLocator
    implements CommandLocator {
        private NullCommandLocator() {
        }

        public AdminCommand.Provider findProvider(String s) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Iterable<AdminCommand.Provider> getAllProviders() {
            return Iterables.empty();
        }
    }
}

