/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.CommandGroup;
import org.neo4j.cli.CommandProvider;
import org.neo4j.cli.CommandType;
import org.neo4j.cli.ExecutionContext;

class AdminToolTest {
    AdminToolTest() {
    }

    @Test
    public void filterShouldKeepAllProvidersThatCreateUniqueCommands() {
        List<CommandProvider> commandProvider = List.of(this.createCommandProvider(CommandType.LOAD, 1), this.createCommandProvider(CommandType.DUMP, 2));
        Collection filterCommandProviders = AdminTool.filterCommandProviders(commandProvider, (CommandGroup)CommandGroup.DATABASE);
        Assertions.assertThat((Iterable)filterCommandProviders).containsAll(commandProvider);
    }

    @Test
    public void filterShouldKeepTheProviderWithHigherPriorityIfBothOfThemCreateTheCommandWithSameType() {
        List<CommandProvider> commandProvider = List.of(this.createCommandProvider(CommandType.LOAD, 2), this.createCommandProvider(CommandType.LOAD, 1));
        Collection filterCommandProviders = AdminTool.filterCommandProviders(commandProvider, (CommandGroup)CommandGroup.DATABASE);
        ((IterableAssert)Assertions.assertThat((Iterable)filterCommandProviders).hasSize(1)).contains((Object[])new CommandProvider[]{commandProvider.get(0)});
    }

    @Test
    public void filterShouldThrowExceptionIfTwoProvidersWithSameTypeCreateSameCommand() {
        List<CommandProvider> enterpriseProviders = List.of(this.createCommandProvider(CommandType.LOAD, 1), this.createCommandProvider(CommandType.LOAD, 1));
        List<CommandProvider> communityProviders = List.of(this.createCommandProvider(CommandType.LOAD, 2), this.createCommandProvider(CommandType.LOAD, 2));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> AdminTool.filterCommandProviders((Collection)communityProviders, (CommandGroup)CommandGroup.DATABASE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> AdminTool.filterCommandProviders((Collection)enterpriseProviders, (CommandGroup)CommandGroup.DATABASE));
    }

    private CommandProvider createCommandProvider(final CommandType commandType, final int priority) {
        return new CommandProvider(){

            public AbstractCommand createCommand(ExecutionContext ctx) {
                return null;
            }

            public CommandType commandType() {
                return commandType;
            }

            public int getPriority() {
                return priority;
            }
        };
    }
}

