/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.concurrent.DecayingFlags;

class DecayingFlagsTest {
    DecayingFlagsTest() {
    }

    @Test
    void shouldTrackToggle() {
        DecayingFlags.Key myFeature = new DecayingFlags.Key(1);
        DecayingFlags set = new DecayingFlags(1);
        set.flag(myFeature);
        Assertions.assertEquals((Object)"4000", (Object)set.asHex());
    }

    @Test
    void shouldTrackMultipleFlags() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(1);
        DecayingFlags.Key featureB = new DecayingFlags.Key(3);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.flag(featureA);
        set.flag(featureB);
        Assertions.assertEquals((Object)"5000", (Object)set.asHex());
    }

    @Test
    void toggleShouldDecay() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(1);
        DecayingFlags.Key featureB = new DecayingFlags.Key(3);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.flag(featureA);
        set.flag(featureB);
        set.sweep();
        Assertions.assertEquals((Object)"4000", (Object)set.asHex());
        set.sweep();
        Assertions.assertEquals((Object)"0000", (Object)set.asHex());
    }

    @Test
    void resetFlagShouldRecoverIfToggledAgain() {
        DecayingFlags.Key featureA = new DecayingFlags.Key(9);
        DecayingFlags set = new DecayingFlags(2);
        set.flag(featureA);
        set.sweep();
        Assertions.assertEquals((Object)"0000", (Object)set.asHex());
        set.flag(featureA);
        Assertions.assertEquals((Object)"0040", (Object)set.asHex());
    }
}

