/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Test;
import org.neo4j.util.concurrent.RecentK;

class RecentKTest {
    RecentKTest() {
    }

    @Test
    void shouldEvictOnOverflow() {
        MatcherAssert.assertThat(this.appendSequence(1, 1, 1, 1, 1, 1, 1), this.yieldsSet(1));
        MatcherAssert.assertThat(this.appendSequence(1, 2, 3, 4, 1, 1, 1), this.yieldsSet(1, 3, 4));
        MatcherAssert.assertThat(this.appendSequence(1, 1, 1, 2, 2, 6, 4, 4, 1, 1, 2, 2, 2, 5, 5), this.yieldsSet(1, 2, 5));
    }

    private Matcher<RecentK<Integer>> yieldsSet(final Integer ... expectedItems) {
        return new TypeSafeMatcher<RecentK<Integer>>(){

            protected boolean matchesSafely(RecentK<Integer> recentK) {
                MatcherAssert.assertThat((Object)recentK.recentItems(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedItems));
                MatcherAssert.assertThat((Object)recentK.recentItems().size(), (Matcher)CoreMatchers.equalTo((Object)expectedItems.length));
                return true;
            }

            public void describeTo(Description description) {
                description.appendValueList("[", ",", "]", (Object[])expectedItems);
            }
        };
    }

    private RecentK<Integer> appendSequence(int ... items) {
        RecentK recentK = new RecentK(3);
        for (int item : items) {
            recentK.add((Object)item);
        }
        return recentK;
    }
}

