/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

class ArrayQueueOutOfOrderSequenceTest {
    private final long[] EMPTY_META = new long[]{42L};

    ArrayQueueOutOfOrderSequenceTest() {
    }

    @Test
    void shouldExposeGapFreeSequenceSingleThreaded() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10, new long[1]);
        sequence.offer(1L, new long[]{1L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        sequence.offer(2L, new long[]{2L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        sequence.offer(4L, new long[]{3L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        sequence.offer(3L, new long[]{4L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        sequence.offer(5L, new long[]{5L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        sequence.offer(10L, new long[]{6L});
        sequence.offer(11L, new long[]{7L});
        sequence.offer(8L, new long[]{8L});
        sequence.offer(9L, new long[]{9L});
        sequence.offer(7L, new long[]{10L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        sequence.offer(6L, new long[]{11L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 11L, new long[]{7L});
    }

    @Test
    void shouldExtendArrayIfNeedBe() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        sequence.offer(3L, new long[]{0L});
        sequence.offer(2L, new long[]{1L});
        sequence.offer(5L, new long[]{2L});
        sequence.offer(4L, new long[]{3L});
        sequence.offer(6L, new long[]{4L});
        sequence.offer(1L, new long[]{5L});
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 6L, new long[]{4L});
    }

    @Test
    void shouldDealWithThisScenario() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sequence.offer(1L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(3L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(4L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sequence.offer(2L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(6L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sequence.offer(5L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(8L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(9L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(10L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(11L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(12L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(13L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)sequence.offer(14L, new long[]{0L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)sequence.offer(7L, new long[]{0L}));
        ArrayQueueOutOfOrderSequenceTest.assertGet((OutOfOrderSequence)sequence, 14L, new long[]{0L});
    }

    /*
     * Exception decompiling
     */
    @Test
    void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    void highestEverSeenTest() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, this.EMPTY_META);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)sequence.highestEverSeen());
        sequence.offer(1L, this.EMPTY_META);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)sequence.highestEverSeen());
        sequence.offer(42L, this.EMPTY_META);
        org.junit.jupiter.api.Assertions.assertEquals((long)42L, (long)sequence.highestEverSeen());
    }

    @Test
    void shouldSnapshotState() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(2L, 8, new long[]{1L, 2L});
        sequence.offer(3L, new long[]{3L, 4L});
        sequence.offer(10L, new long[]{10L, 11L});
        sequence.offer(12L, new long[]{12L, 13L});
        sequence.offer(6L, new long[]{6L, 7L});
        OutOfOrderSequence.Snapshot snapshot = sequence.snapshot();
        sequence.offer(8L, new long[]{8L, 9L});
        sequence.offer(4L, new long[]{4L, 5L});
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{3L, 3L, 4L}, (long[])snapshot.highestGapFree());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)snapshot.idsOutOfOrder().length);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{6L, 6L, 7L}, (long[])snapshot.idsOutOfOrder()[0]);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{10L, 10L, 11L}, (long[])snapshot.idsOutOfOrder()[1]);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{12L, 12L, 13L}, (long[])snapshot.idsOutOfOrder()[2]);
    }

    @Test
    void shouldSnapshotUnderStress() throws Throwable {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 8, new long[]{0L, 0L});
        int threads = Integer.max(2, Runtime.getRuntime().availableProcessors() - 1);
        ExecutorService executorService = Executors.newFixedThreadPool(threads + 1);
        AtomicLong nextNumber = new AtomicLong(1L);
        final AtomicInteger snapshots = new AtomicInteger(10);
        for (int i = 0; i < threads; ++i) {
            executorService.submit(() -> ArrayQueueOutOfOrderSequenceTest.lambda$shouldSnapshotUnderStress$4(snapshots, nextNumber, (OutOfOrderSequence)sequence));
        }
        executorService.submit(new Callable<Void>((OutOfOrderSequence)sequence){
            final /* synthetic */ OutOfOrderSequence val$sequence;
            {
                this.val$sequence = outOfOrderSequence;
            }

            @Override
            public Void call() throws InterruptedException {
                while (snapshots.get() > 0) {
                    OutOfOrderSequence.Snapshot snapshot = this.val$sequence.snapshot();
                    this.verifyInternallyConsistent(snapshot.highestGapFree());
                    for (long[] data : snapshot.idsOutOfOrder()) {
                        this.verifyInternallyConsistent(data);
                    }
                    Thread.sleep(1L);
                    snapshots.decrementAndGet();
                }
                return null;
            }

            private void verifyInternallyConsistent(long[] data) {
                long number = data[0];
                for (int i = 1; i < data.length; ++i) {
                    org.junit.jupiter.api.Assertions.assertEquals((long)(number * (long)(1 + i)), (long)data[i]);
                }
            }
        });
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
    }

    @Test
    void shouldThrowOnOfferingLowerOrEqualToHighestGapFree() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(4L, 10, new long[]{0L});
        Assertions.assertThatThrownBy(() -> ArrayQueueOutOfOrderSequenceTest.lambda$shouldThrowOnOfferingLowerOrEqualToHighestGapFree$5((OutOfOrderSequence)sequence)).isInstanceOf(IllegalStateException.class);
    }

    private static void assertGet(OutOfOrderSequence sequence, long number, long[] meta) {
        long[] data = sequence.get();
        long[] expected = new long[meta.length + 1];
        expected[0] = number;
        System.arraycopy(meta, 0, expected, 1, meta.length);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expected, (long[])data);
    }

    private static /* synthetic */ void lambda$shouldThrowOnOfferingLowerOrEqualToHighestGapFree$5(OutOfOrderSequence sequence) throws Throwable {
        sequence.offer(4L, new long[]{3L});
    }

    private static /* synthetic */ void lambda$shouldSnapshotUnderStress$4(AtomicInteger snapshots, AtomicLong nextNumber, OutOfOrderSequence sequence) {
        while (snapshots.get() > 0) {
            long number = nextNumber.getAndIncrement();
            sequence.offer(number, new long[]{number * 2L, number * 3L});
        }
    }

    private static /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$3(AtomicLong numberSource, Runnable verifier) {
        while (numberSource.get() < 10000000L) {
            verifier.run();
        }
    }

    private static /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$2(OutOfOrderSequence sequence, LongFunction metaFunction) {
        long[] highest = sequence.get();
        long[] expectedMeta = (long[])metaFunction.apply(highest[0]);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expectedMeta, (long[])Arrays.copyOfRange(highest, 1, highest.length));
    }

    private static /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$1(AtomicLong numberSource, OutOfOrderSequence sequence, LongFunction metaFunction) {
        long number;
        while ((number = numberSource.incrementAndGet()) < 10000000L) {
            sequence.offer(number, (long[])metaFunction.apply(number));
        }
    }
}

