/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.concurrent.BinaryLatch;

class BinaryLatchTest {
    BinaryLatchTest() {
    }

    @Test
    void releaseThenAwaitDoesNotBlock() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(30L), () -> {
            BinaryLatch latch = new BinaryLatch();
            latch.release();
            latch.await();
        });
    }

    @Test
    void releaseMustUnblockAwaiters() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(30L), () -> {
            BinaryLatch latch = new BinaryLatch();
            Runnable awaiter = () -> ((BinaryLatch)latch).await();
            int awaiters = 10;
            Thread[] threads = new Thread[awaiters];
            for (int i = 0; i < awaiters; ++i) {
                threads[i] = new Thread(awaiter);
                threads[i].start();
            }
            long deadline = TimeUnit.SECONDS.toNanos(10L) + System.nanoTime();
            while (deadline - System.nanoTime() > 0L && threads[0].getState() != Thread.State.WAITING) {
                Thread.sleep(10L);
            }
            threads[0].join(10L);
            try {
                Assertions.assertEquals((Object)((Object)Thread.State.WAITING), (Object)((Object)threads[0].getState()));
            }
            finally {
                latch.release();
                for (Thread thread : threads) {
                    thread.join();
                }
            }
        });
    }

    @Test
    void stressLatch() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(60L), () -> {
            AtomicReference<BinaryLatch> latchRef = new AtomicReference<BinaryLatch>(new BinaryLatch());
            Runnable awaiter = () -> {
                BinaryLatch latch;
                while ((latch = (BinaryLatch)latchRef.get()) != null) {
                    latch.await();
                }
            };
            int awaiters = 6;
            Thread[] threads = new Thread[awaiters];
            for (int i = 0; i < awaiters; ++i) {
                threads[i] = new Thread(awaiter);
                threads[i].start();
            }
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            for (int i = 0; i < 50000; ++i) {
                latchRef.getAndSet(new BinaryLatch()).release();
                BinaryLatchTest.spin(rng.nextLong(0L, 10L));
            }
            ((BinaryLatch)latchRef.getAndSet(null)).release();
            for (Thread thread : threads) {
                thread.join();
            }
        });
    }

    private static void spin(long micros) {
        long now;
        if (micros == 0L) {
            return;
        }
        long deadline = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while ((now = System.nanoTime()) < deadline) {
        }
    }
}

