/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.concurrent.Futures;

class FuturesTest {
    private static final Runnable NOOP = () -> {};

    FuturesTest() {
    }

    @Test
    void combinedFutureShouldGetResultsAfterAllComplete() throws Exception {
        FutureTask<String> task1 = new FutureTask<String>(NOOP, "1");
        FutureTask<String> task2 = new FutureTask<String>(NOOP, "2");
        FutureTask<String> task3 = new FutureTask<String>(NOOP, "3");
        Future combined = Futures.combine((Future[])new Future[]{task1, task2, task3});
        org.junit.jupiter.api.Assertions.assertThrows(TimeoutException.class, () -> combined.get(10L, TimeUnit.MILLISECONDS));
        task3.run();
        task2.run();
        org.junit.jupiter.api.Assertions.assertThrows(TimeoutException.class, () -> combined.get(10L, TimeUnit.MILLISECONDS));
        task1.run();
        List result = (List)combined.get();
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"1", "2", "3"});
    }
}

