/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.util.concurrent.Runnables;

class RunnablesTest {
    RunnablesTest() {
    }

    @Test
    void runAllMustRunAll() {
        Task task1 = new Task();
        Task task2 = new Task();
        Task task3 = new Task();
        Runnables.runAll((String)"", (Runnable[])new Runnable[]{task1, task2, task3});
        RunnablesTest.assertRun(task1, task2, task3);
    }

    @Test
    void runAllMustRunAllAndPropagateError() {
        Task task1 = new Task();
        Task task2 = new Task();
        Task task3 = new Task();
        Error expectedError = new Error("Killroy was here");
        Runnable throwingTask = RunnablesTest.error(expectedError);
        List<Runnable> runnables = Arrays.asList(task1, task2, task3, throwingTask);
        Collections.shuffle(runnables);
        String failureMessage = "Something wrong, Killroy must be here somewhere.";
        Throwable actual = Assertions.assertThrows(Error.class, () -> Runnables.runAll((String)failureMessage, (Runnable[])runnables.toArray(new Runnable[0])));
        RunnablesTest.assertRun(task1, task2, task3);
        Assertions.assertSame((Object)expectedError, (Object)actual);
        Assertions.assertEquals((int)0, (int)actual.getSuppressed().length);
        Assertions.assertEquals((Object)expectedError.getMessage(), (Object)actual.getMessage());
    }

    @Test
    void runAllMustRunAllAndPropagateMultipleErrors() {
        Task task1 = new Task();
        Task task2 = new Task();
        Task task3 = new Task();
        Error expectedError = new Error("Killroy was here");
        Runnable throwingTask1 = RunnablesTest.error(expectedError);
        RuntimeException expectedException = new RuntimeException("and here");
        Runnable throwingTask2 = RunnablesTest.runtimeException(expectedException);
        List<Runnable> runnables = Arrays.asList(task1, task2, task3, throwingTask1, throwingTask2);
        Collections.shuffle(runnables);
        String failureMessage = "Something wrong, Killroy must be here somewhere.";
        RuntimeException actual = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> Runnables.runAll((String)failureMessage, (Runnable[])runnables.toArray(new Runnable[0])));
        RunnablesTest.assertRun(task1, task2, task3);
        Assertions.assertTrue((boolean)Exceptions.findCauseOrSuppressed((Throwable)actual, t -> t == expectedError).isPresent());
        Assertions.assertTrue((boolean)Exceptions.findCauseOrSuppressed((Throwable)actual, t -> t == expectedException).isPresent());
        Assertions.assertEquals((Object)failureMessage, (Object)actual.getMessage());
    }

    @Test
    void runAllMustRunAllAndPropagateSingleErrorAsIs() {
        Task task1 = new Task();
        Task task2 = new Task();
        Task task3 = new Task();
        RuntimeException expectedError = new RuntimeException("Killroy was here");
        Runnable throwingTask1 = RunnablesTest.runtimeException(expectedError);
        List<Runnable> runnables = Arrays.asList(task1, throwingTask1, task2, task3);
        Collections.shuffle(runnables);
        RuntimeException actual = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> Runnables.runAll((String)"something", (Runnable[])runnables.toArray(new Runnable[0])));
        RunnablesTest.assertRun(task1, task2, task3);
        Assertions.assertSame((Object)expectedError, (Object)actual);
    }

    private static Runnable error(Error error) {
        return () -> {
            throw error;
        };
    }

    private static Runnable runtimeException(RuntimeException runtimeException) {
        return () -> {
            throw runtimeException;
        };
    }

    private static void assertRun(Task ... tasks) {
        for (Task task : tasks) {
            Assertions.assertTrue((boolean)task.run, (String)"didn't run all expected tasks");
        }
    }

    private static class Task
    implements Runnable {
        private boolean run;

        private Task() {
        }

        @Override
        public void run() {
            this.run = true;
        }
    }
}

