/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.time.Duration;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.configuration.ConfigValue;

public class ConfigValueTest {
    @Test
    public void handlesEmptyValue() throws Exception {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.empty(), "description", false, false, Optional.empty());
        Assert.assertEquals(Optional.empty(), (Object)value.value());
        Assert.assertEquals((Object)"null", (Object)value.toString());
        Assert.assertFalse((boolean)value.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)value.replacement());
        Assert.assertFalse((boolean)value.internal());
    }

    @Test
    public void handlesInternal() throws Exception {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.empty(), "description", true, false, Optional.empty());
        Assert.assertTrue((boolean)value.internal());
    }

    @Test
    public void handlesNonEmptyValue() throws Exception {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.of(1), "description", false, false, Optional.empty());
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertFalse((boolean)value.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)value.replacement());
        Assert.assertFalse((boolean)value.internal());
    }

    @Test
    public void handlesDeprecationAndReplacement() throws Exception {
        ConfigValue value = new ConfigValue("old_name", Optional.empty(), Optional.empty(), Optional.of(1), "description", false, true, Optional.of("new_name"));
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertTrue((boolean)value.deprecated());
        Assert.assertEquals((Object)"new_name", value.replacement().get());
        Assert.assertFalse((boolean)value.internal());
    }

    @Test
    public void handlesValueDescription() throws Exception {
        ConfigValue value = new ConfigValue("old_name", Optional.empty(), Optional.empty(), Optional.of(1), "a simple integer", false, true, Optional.of("new_name"));
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertTrue((boolean)value.deprecated());
        Assert.assertEquals((Object)"new_name", value.replacement().get());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertEquals((Object)"a simple integer", (Object)value.valueDescription());
    }

    @Test
    public void durationValueIsRepresentedWithUnit() throws Exception {
        Assert.assertEquals((Object)"120000ms", (Object)ConfigValue.valueToString((Object)Duration.ofMinutes(2L)));
    }

    @Test
    public void stringValueIsRepresentedAsString() throws Exception {
        Assert.assertEquals((Object)"bob", (Object)ConfigValue.valueToString((Object)"bob"));
    }

    @Test
    public void intValueIsRepresentedAsInt() throws Exception {
        Assert.assertEquals((Object)"7", (Object)ConfigValue.valueToString((Object)7));
    }

    @Test
    public void nullIsHandled() throws Exception {
        Assert.assertEquals((Object)"null", (Object)ConfigValue.valueToString(null));
    }
}

