/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;

public class ConfigOptionsTest {
    private Setting<Integer> setting = new BaseSetting<Integer>(){

        public String name() {
            return "myInt";
        }

        public void withScope(Function<String, String> scopingRule) {
        }

        public String getDefaultValue() {
            return "1";
        }

        public Integer from(Configuration config) {
            return (Integer)config.get((Setting)this);
        }

        public Integer apply(Function<String, String> provider) {
            return Integer.parseInt(provider.apply(this.name()));
        }

        public String valueDescription() {
            return "a special test integer";
        }
    };
    private ConfigOptions configOptions;

    @Before
    public void setup() {
        this.configOptions = new ConfigOptions(this.setting);
    }

    @Test
    public void setting() throws Exception {
        Assert.assertEquals(this.setting, (Object)this.configOptions.settingGroup());
    }

    @Test
    public void asConfigValue() throws Exception {
        List values = this.configOptions.asConfigValues(Collections.singletonMap("myInt", "123"));
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals(Optional.of(123), (Object)((ConfigValue)values.get(0)).value());
        Assert.assertEquals((Object)"myInt", (Object)((ConfigValue)values.get(0)).name());
        Assert.assertEquals(Optional.empty(), (Object)((ConfigValue)values.get(0)).description());
        Assert.assertEquals((Object)"a special test integer", (Object)((ConfigValue)values.get(0)).valueDescription());
    }
}

