/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;

public class LoadableConfigTest {
    @Test
    public void getConfigOptions() throws Exception {
        Map config = MapUtil.stringMap((String[])new String[]{"myInt", "123", "myString", "bah", "myOldString", "moo"});
        TestConfig testSettings = new TestConfig();
        List options = testSettings.getConfigOptions();
        Assert.assertEquals((long)3L, (long)options.size());
        Assert.assertEquals((Object)1, ((ConfigOptions)options.get(0)).settingGroup().values(Collections.emptyMap()).get("myInt"));
        Assert.assertEquals((Object)123, ((ConfigOptions)options.get(0)).settingGroup().values(config).get("myInt"));
        Assert.assertEquals(Optional.empty(), (Object)((ConfigOptions)options.get(0)).settingGroup().description());
        Assert.assertFalse((boolean)((ConfigOptions)options.get(0)).settingGroup().deprecated());
        Assert.assertEquals(Optional.empty(), (Object)((ConfigOptions)options.get(0)).settingGroup().replacement());
        Assert.assertEquals((Object)"bob", ((ConfigOptions)options.get(1)).settingGroup().values(Collections.emptyMap()).get("myString"));
        Assert.assertEquals((Object)"bah", ((ConfigOptions)options.get(1)).settingGroup().values(config).get("myString"));
        Assert.assertEquals((Object)"A string setting", ((ConfigOptions)options.get(1)).settingGroup().description().get());
        Assert.assertFalse((boolean)((ConfigOptions)options.get(1)).settingGroup().deprecated());
        Assert.assertEquals(Optional.empty(), (Object)((ConfigOptions)options.get(1)).settingGroup().replacement());
        Assert.assertEquals((Object)"tim", ((ConfigOptions)options.get(2)).settingGroup().values(Collections.emptyMap()).get("myOldString"));
        Assert.assertEquals((Object)"moo", ((ConfigOptions)options.get(2)).settingGroup().values(config).get("myOldString"));
        Assert.assertEquals((Object)"A deprecated string setting", ((ConfigOptions)options.get(2)).settingGroup().description().get());
        Assert.assertTrue((boolean)((ConfigOptions)options.get(2)).settingGroup().deprecated());
        Assert.assertEquals((Object)"myString", ((ConfigOptions)options.get(2)).settingGroup().replacement().get());
    }

    private static abstract class StringSetting
    extends BaseSetting<String> {
        private StringSetting() {
        }

        public String valueDescription() {
            return "a String";
        }
    }

    private static class TestConfig
    implements LoadableConfig {
        public static final Setting<Integer> integer = new BaseSetting<Integer>(){

            public String valueDescription() {
                return "an Integer";
            }

            public String name() {
                return "myInt";
            }

            public void withScope(Function<String, String> scopingRule) {
            }

            public String getDefaultValue() {
                return "1";
            }

            public Integer from(Configuration config) {
                return (Integer)config.get((Setting)this);
            }

            public Integer apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return Integer.parseInt(val);
            }
        };
        @Description(value="A string setting")
        public static final Setting<String> string = new StringSetting(){

            public String apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return val;
            }

            public String name() {
                return "myString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "bob";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };
        @Description(value="A deprecated string setting")
        @Deprecated
        @ReplacedBy(value="myString")
        public static final Setting<String> oldString = new StringSetting(){

            public String apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return val;
            }

            public String name() {
                return "myOldString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "tim";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };
        @Description(value="A private setting which is not accessible")
        private static final Setting<String> ignoredSetting = new StringSetting(){

            public String apply(Function<String, String> provider) {
                return provider.apply(this.name());
            }

            public String name() {
                return "myString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "bob";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };

        private TestConfig() {
        }
    }
}

