/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.time.Duration;
import java.util.Optional;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ConfigValue;

class ConfigValueTest {
    ConfigValueTest() {
    }

    @Test
    void handlesEmptyValue() {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.empty(), "description", false, false, false, Optional.empty(), false);
        Assert.assertEquals(Optional.empty(), (Object)value.value());
        Assert.assertEquals((Object)"null", (Object)value.toString());
        Assert.assertFalse((boolean)value.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)value.replacement());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertFalse((boolean)value.secret());
    }

    @Test
    void handlesInternal() {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.empty(), "description", true, false, false, Optional.empty(), false);
        Assert.assertTrue((boolean)value.internal());
        Assert.assertFalse((boolean)value.secret());
    }

    @Test
    void handlesNonEmptyValue() {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.of(1), "description", false, false, false, Optional.empty(), false);
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertFalse((boolean)value.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)value.replacement());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertFalse((boolean)value.secret());
    }

    @Test
    void handlesDeprecationAndReplacement() {
        ConfigValue value = new ConfigValue("old_name", Optional.empty(), Optional.empty(), Optional.of(1), "description", false, false, true, Optional.of("new_name"), false);
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertTrue((boolean)value.deprecated());
        Assert.assertEquals((Object)"new_name", value.replacement().get());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertFalse((boolean)value.secret());
    }

    @Test
    void handlesValueDescription() {
        ConfigValue value = new ConfigValue("old_name", Optional.empty(), Optional.empty(), Optional.of(1), "a simple integer", false, false, true, Optional.of("new_name"), false);
        Assert.assertEquals(Optional.of(1), (Object)value.value());
        Assert.assertEquals((Object)"1", (Object)value.toString());
        Assert.assertTrue((boolean)value.deprecated());
        Assert.assertEquals((Object)"new_name", value.replacement().get());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertFalse((boolean)value.secret());
        Assert.assertEquals((Object)"a simple integer", (Object)value.valueDescription());
    }

    @Test
    public void handlesSecretValue() throws Exception {
        ConfigValue value = new ConfigValue("name", Optional.empty(), Optional.empty(), Optional.of("secret"), "description", false, false, false, Optional.empty(), true);
        Assert.assertEquals(Optional.of("secret"), (Object)value.value());
        Assert.assertEquals((Object)"##########", (Object)value.toString());
        Assert.assertFalse((boolean)value.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)value.replacement());
        Assert.assertFalse((boolean)value.internal());
        Assert.assertTrue((boolean)value.secret());
    }

    @Test
    void durationValueIsRepresentedWithUnit() {
        Assert.assertEquals((Object)"120000ms", (Object)ConfigValue.valueToString((Object)Duration.ofMinutes(2L)));
    }

    @Test
    void stringValueIsRepresentedAsString() {
        Assert.assertEquals((Object)"bob", (Object)ConfigValue.valueToString((Object)"bob"));
    }

    @Test
    void intValueIsRepresentedAsInt() {
        Assert.assertEquals((Object)"7", (Object)ConfigValue.valueToString((Object)7));
    }

    @Test
    void nullIsHandled() {
        Assert.assertEquals((Object)"null", (Object)ConfigValue.valueToString(null));
    }
}

