/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Dynamic;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingGroup;
import org.neo4j.helpers.collection.MapUtil;

class LoadableConfigTest {
    LoadableConfigTest() {
    }

    @Test
    void getConfigOptions() {
        Map config = MapUtil.stringMap((String[])new String[]{TestConfig.integer.name(), "123", TestConfig.string.name(), "bah", TestConfig.oldString.name(), "moo", TestConfig.dynamic.name(), "foo"});
        TestConfig testSettings = new TestConfig();
        List options = testSettings.getConfigOptions();
        Assertions.assertEquals((int)4, (int)options.size());
        SettingGroup integerSetting = ((ConfigOptions)options.get(0)).settingGroup();
        Assertions.assertEquals((Object)1, integerSetting.values(Collections.emptyMap()).get(TestConfig.integer.name()));
        Assertions.assertEquals((Object)123, integerSetting.values(config).get(TestConfig.integer.name()));
        Assertions.assertEquals(Optional.empty(), (Object)integerSetting.description());
        Assertions.assertFalse((boolean)integerSetting.deprecated());
        Assertions.assertFalse((boolean)integerSetting.dynamic());
        Assertions.assertEquals(Optional.empty(), (Object)integerSetting.replacement());
        SettingGroup stringSetting = ((ConfigOptions)options.get(1)).settingGroup();
        Assertions.assertEquals((Object)"bob", stringSetting.values(Collections.emptyMap()).get(TestConfig.string.name()));
        Assertions.assertEquals((Object)"bah", stringSetting.values(config).get(TestConfig.string.name()));
        Assertions.assertEquals((Object)"A string setting", stringSetting.description().get());
        Assertions.assertFalse((boolean)stringSetting.deprecated());
        Assertions.assertFalse((boolean)stringSetting.dynamic());
        Assertions.assertEquals(Optional.empty(), (Object)stringSetting.replacement());
        SettingGroup oldStringSetting = ((ConfigOptions)options.get(2)).settingGroup();
        Assertions.assertEquals((Object)"tim", oldStringSetting.values(Collections.emptyMap()).get(TestConfig.oldString.name()));
        Assertions.assertEquals((Object)"moo", oldStringSetting.values(config).get(TestConfig.oldString.name()));
        Assertions.assertEquals((Object)"A deprecated string setting", oldStringSetting.description().get());
        Assertions.assertTrue((boolean)oldStringSetting.deprecated());
        Assertions.assertFalse((boolean)oldStringSetting.dynamic());
        Assertions.assertEquals((Object)TestConfig.string.name(), oldStringSetting.replacement().get());
        SettingGroup dynamicSetting = ((ConfigOptions)options.get(3)).settingGroup();
        Assertions.assertEquals((Object)"defaultDynamic", dynamicSetting.values(Collections.emptyMap()).get(TestConfig.dynamic.name()));
        Assertions.assertEquals((Object)"foo", dynamicSetting.values(config).get(TestConfig.dynamic.name()));
        Assertions.assertEquals((Object)"A dynamic string setting", dynamicSetting.description().get());
        Assertions.assertFalse((boolean)dynamicSetting.deprecated());
        Assertions.assertTrue((boolean)dynamicSetting.dynamic());
        Assertions.assertEquals(Optional.empty(), (Object)dynamicSetting.replacement());
    }

    private static abstract class StringSetting
    extends BaseSetting<String> {
        private StringSetting() {
        }

        public String valueDescription() {
            return "a String";
        }
    }

    private static class TestConfig
    implements LoadableConfig {
        public static final Setting<Integer> integer = new BaseSetting<Integer>(){

            public String valueDescription() {
                return "an Integer";
            }

            public String name() {
                return "myInt";
            }

            public void withScope(Function<String, String> scopingRule) {
            }

            public String getDefaultValue() {
                return "1";
            }

            public Integer from(Configuration config) {
                return (Integer)config.get((Setting)this);
            }

            public Integer apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return Integer.parseInt(val);
            }
        };
        @Description(value="A string setting")
        public static final Setting<String> string = new StringSetting(){

            public String apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return val;
            }

            public String name() {
                return "myString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "bob";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };
        @Description(value="A deprecated string setting")
        @Deprecated
        @ReplacedBy(value="myString")
        public static final Setting<String> oldString = new StringSetting(){

            public String apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return val;
            }

            public String name() {
                return "myOldString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "tim";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };
        @Description(value="A private setting which is not accessible")
        private static final Setting<String> ignoredSetting = new StringSetting(){

            public String apply(Function<String, String> provider) {
                return provider.apply(this.name());
            }

            public String name() {
                return "myString";
            }

            public void withScope(Function<String, String> function) {
            }

            public String getDefaultValue() {
                return "bob";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };
        @Description(value="A dynamic string setting")
        @Dynamic
        public static final Setting<String> dynamic = new StringSetting(){

            public String apply(Function<String, String> provider) {
                String val = provider.apply(this.name());
                if (val == null) {
                    val = this.getDefaultValue();
                }
                return val;
            }

            public String name() {
                return "myDynamicProperty";
            }

            public void withScope(Function<String, String> scopingRule) {
            }

            public String getDefaultValue() {
                return "defaultDynamic";
            }

            public String from(Configuration configuration) {
                return (String)configuration.get((Setting)this);
            }
        };

        private TestConfig() {
        }
    }
}

