/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.GroupSettingValidator;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ConfigTest {
    @Inject
    private TestDirectory testDirectory;

    ConfigTest() {
    }

    @Test
    void testLoadSettingsToConfig() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        Assertions.assertEquals((Object)"hello", (Object)config.get(TestSettings.stringSetting));
        Assertions.assertEquals((int)1, (Integer)((Integer)config.get(TestSettings.intSetting)));
        Assertions.assertNull((Object)config.get(TestSettings.boolSetting));
    }

    @Test
    void testFetchAbsentSetting() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        Setting absentSetting = SettingImpl.newBuilder((String)"test.absent.bool", (SettingValueParser)SettingValueParsers.BOOL, null).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.get(absentSetting));
    }

    @Test
    void testUpdateValue() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).set(TestSettings.intSetting, (Object)3).build();
        Assertions.assertEquals((int)3, (Integer)((Integer)config.get(TestSettings.intSetting)));
        config.setDynamic(TestSettings.intSetting, (Object)2, this.getClass().getSimpleName());
        Assertions.assertEquals((int)2, (Integer)((Integer)config.get(TestSettings.intSetting)));
        config.setDynamic(TestSettings.intSetting, null, this.getClass().getSimpleName());
        Assertions.assertEquals((int)1, (Integer)((Integer)config.get(TestSettings.intSetting)));
    }

    @Test
    void testOverrideAbsentSetting() {
        Map<String, String> settings = Map.of("test.absent.bool", "false");
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).addSettingsClass(TestSettings.class).setRaw(settings);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
    }

    @Test
    void testOverrideDefault() {
        Map<Setting<Boolean>, Boolean> overriddenDefaults = Map.of(TestSettings.stringSetting, "foo", TestSettings.intSetting, 11, TestSettings.boolSetting, true);
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).setDefaults(overriddenDefaults).build();
        Assertions.assertEquals((Object)"foo", (Object)config.get(TestSettings.stringSetting));
        Assertions.assertEquals((int)11, (Integer)((Integer)config.get(TestSettings.intSetting)));
        Assertions.assertEquals((Object)true, (Object)config.get(TestSettings.boolSetting));
    }

    @Test
    void testUpdateStatic() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setDynamic(TestSettings.stringSetting, (Object)"not allowed", this.getClass().getSimpleName()));
        Assertions.assertEquals((Object)"hello", (Object)config.get(TestSettings.stringSetting));
        config.set(TestSettings.stringSetting, (Object)"allowed internally");
        Assertions.assertEquals((Object)"allowed internally", (Object)config.get(TestSettings.stringSetting));
    }

    @Test
    void testUpdateImmutable() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setDynamic(TestSettings.boolSetting, (Object)true, this.getClass().getSimpleName()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.set(TestSettings.boolSetting, (Object)true));
    }

    @Test
    void testObserver() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        MutableInt observedOld = new MutableInt(0);
        MutableInt observedNew = new MutableInt(0);
        SettingChangeListener listener = (oldValue, newValue) -> {
            observedOld.setValue((Number)oldValue);
            observedNew.setValue((Number)newValue);
        };
        config.addListener(TestSettings.intSetting, listener);
        Assertions.assertEquals((int)0, (Integer)observedOld.getValue());
        Assertions.assertEquals((int)0, (Integer)observedNew.getValue());
        config.setDynamic(TestSettings.intSetting, (Object)2, this.getClass().getSimpleName());
        Assertions.assertEquals((int)1, (Integer)observedOld.getValue());
        Assertions.assertEquals((int)2, (Integer)observedNew.getValue());
        config.setDynamic(TestSettings.intSetting, (Object)7, this.getClass().getSimpleName());
        Assertions.assertEquals((int)2, (Integer)observedOld.getValue());
        Assertions.assertEquals((int)7, (Integer)observedNew.getValue());
        config.removeListener(TestSettings.intSetting, listener);
        config.setDynamic(TestSettings.intSetting, (Object)9, this.getClass().getSimpleName());
        Assertions.assertEquals((int)2, (Integer)observedOld.getValue());
        Assertions.assertEquals((int)7, (Integer)observedNew.getValue());
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.addListener(TestSettings.boolSetting, (oV, nV) -> {}));
    }

    @Test
    void testGroup() {
        TestConnectionGroupSetting g1 = TestConnectionGroupSetting.group("1");
        TestConnectionGroupSetting g2 = TestConnectionGroupSetting.group("2");
        Config config = Config.newBuilder().addGroupSettingClass(TestConnectionGroupSetting.class).set(g1.port, (Object)1111).set(g1.hostname, (Object)"0.0.0.0").set(g1.secure, (Object)false).set(g2.port, (Object)2222).set(g2.hostname, (Object)"127.0.0.1").build();
        Assertions.assertEquals((int)1111, (Integer)((Integer)config.get(g1.port)));
        Assertions.assertEquals((int)2222, (Integer)((Integer)config.get(g2.port)));
        Assertions.assertEquals((Object)false, (Object)config.get(g1.secure));
        Assertions.assertEquals((Object)true, (Object)config.get(g2.secure));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.get(TestConnectionGroupSetting.group((String)"not_specified_id").port));
    }

    @Test
    void testGroupInheritance() {
        ChildGroup group = new ChildGroup("1");
        Config config = Config.newBuilder().addGroupSettingClass(ChildGroup.class).set(group.childSetting, (Object)"child").build();
        Assertions.assertEquals((Object)"child", (Object)config.get(group.childSetting));
        Assertions.assertEquals((Object)"parent", (Object)config.get(group.parentSetting));
    }

    @Test
    void testValidator() {
        Config.Builder builder = Config.newBuilder().addSettingsClass(TestSettings.class).addGroupSettingClass(TestConnectionGroupSetting.class).addValidator(TestConnectionGroupSetting.class).set(TestConnectionGroupSetting.group((String)"1").port, (Object)1111).set(TestConnectionGroupSetting.group((String)"2").port, (Object)1111);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        Assertions.assertEquals((Object)"Need unique ports", (Object)e.getMessage());
    }

    @Test
    void testInvalidValidator() {
        Config.Builder builder = Config.newBuilder().addValidator(InvalidValidator.class);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        Assertions.assertTrue((boolean)e.getMessage().contains("Failed to create instance of"));
    }

    @Test
    void testMalformedGroupSetting() {
        Map<String, String> settings = Map.of("test.connection.http.1.foo.bar", "1111");
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).addGroupSettingClass(TestConnectionGroupSetting.class).setRaw(settings);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
    }

    @Test
    void testGetGroups() {
        Config config = Config.newBuilder().addGroupSettingClass(TestConnectionGroupSetting.class).set(TestConnectionGroupSetting.group((String)"default").port, (Object)7474).set(TestConnectionGroupSetting.group((String)"1").port, (Object)1111).set(TestConnectionGroupSetting.group((String)"1").hostname, (Object)"0.0.0.0").set(TestConnectionGroupSetting.group((String)"1").secure, (Object)false).set(TestConnectionGroupSetting.group((String)"2").port, (Object)2222).set(TestConnectionGroupSetting.group((String)"2").hostname, (Object)"127.0.0.1").build();
        Map groups = config.getGroups(TestConnectionGroupSetting.class);
        Assertions.assertEquals(Set.of("default", "1", "2"), groups.keySet());
        Assertions.assertEquals((int)7474, (Integer)((Integer)config.get(((TestConnectionGroupSetting)((Object)groups.get((Object)"default"))).port)));
        Assertions.assertEquals((Object)true, (Object)config.get(((TestConnectionGroupSetting)((Object)groups.get((Object)"2"))).secure));
    }

    @Test
    void testFromConfig() {
        Config fromConfig = Config.newBuilder().addSettingsClass(TestSettings.class).setDefault(TestSettings.boolSetting, (Object)false).set(TestSettings.intSetting, (Object)3).build();
        Config config1 = Config.newBuilder().fromConfig(fromConfig).build();
        Assertions.assertEquals((int)3, (Integer)((Integer)config1.get(TestSettings.intSetting)));
        Assertions.assertEquals((Object)"hello", (Object)config1.get(TestSettings.stringSetting));
        Config config2 = Config.newBuilder().fromConfig(fromConfig).set(TestSettings.intSetting, (Object)5).build();
        Assertions.assertEquals((int)5, (Integer)((Integer)config2.get(TestSettings.intSetting)));
        Config config3 = Config.newBuilder().addSettingsClass(TestSettings.class).fromConfig(fromConfig).set(TestSettings.intSetting, (Object)7).build();
        Assertions.assertEquals((int)7, (Integer)((Integer)config3.get(TestSettings.intSetting)));
        Assertions.assertEquals((Object)false, (Object)config3.get(TestSettings.boolSetting));
    }

    @Test
    void shouldThrowIfMultipleFromConfig() {
        Config fromConfig = Config.newBuilder().addSettingsClass(TestSettings.class).setDefault(TestSettings.boolSetting, (Object)false).set(TestSettings.intSetting, (Object)3).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().fromConfig(fromConfig).fromConfig(fromConfig).build());
    }

    @Test
    void testGroupFromConfig() {
        Config fromConfig = Config.newBuilder().addGroupSettingClass(TestConnectionGroupSetting.class).set(TestConnectionGroupSetting.group((String)"default").port, (Object)7474).set(TestConnectionGroupSetting.group((String)"1").port, (Object)1111).set(TestConnectionGroupSetting.group((String)"1").hostname, (Object)"0.0.0.0").set(TestConnectionGroupSetting.group((String)"1").secure, (Object)false).build();
        Config config1 = Config.newBuilder().fromConfig(fromConfig).build();
        Map groups1 = config1.getGroups(TestConnectionGroupSetting.class);
        Assertions.assertEquals(Set.of("default", "1"), groups1.keySet());
        Assertions.assertEquals((int)7474, (Integer)((Integer)config1.get(((TestConnectionGroupSetting)((Object)groups1.get((Object)"default"))).port)));
        Config config2 = Config.newBuilder().fromConfig(fromConfig).addGroupSettingClass(TestConnectionGroupSetting.class).set(TestConnectionGroupSetting.group((String)"1").port, (Object)3333).set(TestConnectionGroupSetting.group((String)"2").port, (Object)2222).set(TestConnectionGroupSetting.group((String)"2").hostname, (Object)"127.0.0.1").build();
        Map groups2 = config2.getGroups(TestConnectionGroupSetting.class);
        Assertions.assertEquals(Set.of("default", "1", "2"), groups2.keySet());
        Assertions.assertEquals((int)7474, (Integer)((Integer)config2.get(((TestConnectionGroupSetting)((Object)groups2.get((Object)"default"))).port)));
        Assertions.assertEquals((int)3333, (Integer)((Integer)config2.get(((TestConnectionGroupSetting)((Object)groups2.get((Object)"1"))).port)));
        Assertions.assertEquals((Object)true, (Object)config2.get(((TestConnectionGroupSetting)((Object)groups2.get((Object)"default"))).secure));
        Assertions.assertEquals((Object)true, (Object)config2.get(((TestConnectionGroupSetting)((Object)groups2.get((Object)"2"))).secure));
    }

    @Test
    void testResolveDefaultSettingDependency() {
        Config.Builder builder = Config.newBuilder().addSettingsClass(DependencySettings.class);
        Config config = builder.build();
        Assertions.assertEquals((Object)config.get(DependencySettings.baseString), (Object)config.get(DependencySettings.dependingString));
        String value = "default overrides dependency";
        builder.setDefault(DependencySettings.dependingString, (Object)value);
        Config config2 = builder.build();
        Assertions.assertEquals((Object)value, (Object)config2.get(DependencySettings.dependingString));
        value = "value overrides dependency";
        builder.set(DependencySettings.dependingString, (Object)value);
        config2 = builder.build();
        Assertions.assertEquals((Object)value, (Object)config2.get(DependencySettings.dependingString));
    }

    @Test
    void testResolvePathSettingDependency() {
        Config config = Config.newBuilder().addSettingsClass(DependencySettings.class).build();
        Assertions.assertEquals((Object)Path.of("/base/", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.basePath));
        Assertions.assertEquals((Object)Path.of("/base/mid/", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.midPath));
        Assertions.assertEquals((Object)Path.of("/base/mid/end/file", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.endPath));
        Assertions.assertEquals((Object)Path.of("/another/path/file", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.absolute));
        config.set(DependencySettings.endPath, (Object)Path.of("/path/another_file", new String[0]));
        config.set(DependencySettings.absolute, (Object)Path.of("path/another_file", new String[0]));
        Assertions.assertEquals((Object)Path.of("/path/another_file", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.endPath));
        Assertions.assertEquals((Object)Path.of("/base/mid/path/another_file", new String[0]).toAbsolutePath(), (Object)config.get(DependencySettings.absolute));
    }

    @Test
    void testResolveBrokenSettingDependency() {
        Config.Builder builder = Config.newBuilder().addSettingsClass(BrokenDependencySettings.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
    }

    @Test
    void testSingleSettingGroup() {
        Map<String, String> fromSettings = Map.of("test.single_setting.default", "default value", "test.single_setting.foo", "foo", "test.single_setting.bar", "bar");
        Config config = Config.newBuilder().addGroupSettingClass(SingleSettingGroup.class).setRaw(fromSettings).build();
        Assertions.assertEquals((int)3, (int)config.getGroups(SingleSettingGroup.class).size());
        Assertions.assertEquals((Object)"default value", (Object)config.get(SingleSettingGroup.group((String)"default").singleSetting));
        Assertions.assertEquals((Object)"foo", (Object)config.get(SingleSettingGroup.group((String)"foo").singleSetting));
        Assertions.assertEquals((Object)"bar", (Object)config.get(SingleSettingGroup.group((String)"bar").singleSetting));
    }

    @Test
    void shouldLogIfConfigFileCouldNotBeFound() {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.file("test.conf", new String[0]);
        Config config = Config.emptyBuilder().fromFileNoThrow(confFile).build();
        config.setLogger(log);
        ((Log)Mockito.verify((Object)log)).warn("Config file [%s] does not exist.", new Object[]{confFile});
    }

    @Test
    void shouldLogIfConfigFileCouldNotBeRead() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(Config.class);
        File confFile = this.testDirectory.file("test.conf", new String[0]);
        Assertions.assertTrue((boolean)confFile.createNewFile());
        this.tryRemoveReadPermissions(confFile);
        Config config = Config.emptyBuilder().fromFileNoThrow(confFile).build();
        config.setLogger(log);
        logProvider.rawMessageMatcher().assertContains("Unable to load config file [%s]");
    }

    @Test
    void canReadConfigFile() throws IOException {
        File confFile = this.testDirectory.file("test.conf", new String[0]);
        Files.write(confFile.toPath(), Collections.singletonList(GraphDatabaseSettings.default_database.name() + "=foo"), new OpenOption[0]);
        Assertions.assertEquals((Object)"foo", (Object)Config.newBuilder().fromFile(confFile).build().get(GraphDatabaseSettings.default_database));
        Assertions.assertEquals((Object)"foo", (Object)Config.newBuilder().fromFileNoThrow(confFile).build().get(GraphDatabaseSettings.default_database));
        Assertions.assertEquals((Object)"foo", (Object)Config.newBuilder().fromFileNoThrow(confFile.toPath()).build().get(GraphDatabaseSettings.default_database));
    }

    @Test
    void mustThrowIfConfigFileCouldNotBeFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            File confFile = this.testDirectory.file("test.conf", new String[0]);
            Config.emptyBuilder().fromFile(confFile).build();
        });
    }

    @Test
    void mustThrowIfConfigFileCoutNotBeRead() throws IOException {
        File confFile = this.testDirectory.file("test.conf", new String[0]);
        Assertions.assertTrue((boolean)confFile.createNewFile());
        this.tryRemoveReadPermissions(confFile);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.emptyBuilder().fromFile(confFile).build());
    }

    @Test
    void mustWarnIfFileContainsDuplicateSettings() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), Arrays.asList(ExternalSettings.initialHeapSize.name() + "=5g", ExternalSettings.initialHeapSize.name() + "=4g", ExternalSettings.initialHeapSize.name() + "=3g", ExternalSettings.maxHeapSize.name() + "=10g", ExternalSettings.maxHeapSize.name() + "=11g"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).setDefault(ExternalSettings.initialHeapSize, (Object)"1g").setDefault(ExternalSettings.initialHeapSize, (Object)"2g").build();
        config.setLogger(log);
        ((Log)Mockito.verify((Object)log)).warn("The '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{ExternalSettings.initialHeapSize.name(), "5g", "4g"});
        ((Log)Mockito.verify((Object)log)).warn("The '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{ExternalSettings.initialHeapSize.name(), "4g", "3g"});
        ((Log)Mockito.verify((Object)log)).warn("The '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{ExternalSettings.maxHeapSize.name(), "10g", "11g"});
    }

    @Test
    void testDisableAllConnectors() {
        Config config = Config.newBuilder().set(BoltConnector.enabled, (Object)true).set(HttpConnector.enabled, (Object)true).set(HttpsConnector.enabled, (Object)true).build();
        ConfigUtils.disableAllConnectors((Config)config);
        Assertions.assertFalse((boolean)((Boolean)config.get(BoltConnector.enabled)));
        Assertions.assertFalse((boolean)((Boolean)config.get(HttpConnector.enabled)));
        Assertions.assertFalse((boolean)((Boolean)config.get(HttpsConnector.enabled)));
    }

    @Test
    void testAmendIfNotSet() {
        Config config = Config.newBuilder().addSettingsClass(TestSettings.class).build();
        config.setIfNotSet(TestSettings.intSetting, (Object)77);
        Assertions.assertEquals((int)77, (Integer)((Integer)config.get(TestSettings.intSetting)));
        Config configWithSetting = Config.newBuilder().addSettingsClass(TestSettings.class).set(TestSettings.intSetting, (Object)66).build();
        configWithSetting.setIfNotSet(TestSettings.intSetting, (Object)77);
        Assertions.assertEquals((int)66, (Integer)((Integer)configWithSetting.get(TestSettings.intSetting)));
    }

    @Test
    void testIsExplicitlySet() {
        Config config = Config.emptyBuilder().addSettingsClass(TestSettings.class).build();
        Assertions.assertFalse((boolean)config.isExplicitlySet(TestSettings.intSetting));
        config.set(TestSettings.intSetting, (Object)77);
        Assertions.assertTrue((boolean)config.isExplicitlySet(TestSettings.intSetting));
        Config configWithSetting = Config.emptyBuilder().addSettingsClass(TestSettings.class).set(TestSettings.intSetting, (Object)66).build();
        Assertions.assertTrue((boolean)configWithSetting.isExplicitlySet(TestSettings.intSetting));
        configWithSetting.set(TestSettings.intSetting, null);
        Assertions.assertFalse((boolean)configWithSetting.isExplicitlySet(TestSettings.intSetting));
    }

    @Test
    void testStrictValidation() throws IOException {
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), Collections.singletonList("some_unrecognized_garbage=true"), new OpenOption[0]);
        Config.Builder builder = Config.newBuilder().fromFile(confFile);
        builder.set(GraphDatabaseSettings.strict_config_validation, (Object)true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        builder.set(GraphDatabaseSettings.strict_config_validation, (Object)false);
        Assertions.assertDoesNotThrow(() -> ((Config.Builder)builder).build());
    }

    @Test
    void testIncorrectType() {
        Map<Setting<Integer>, String> cfgMap = Map.of(TestSettings.intSetting, "not an int");
        Config.Builder builder = Config.newBuilder().addSettingsClass(TestSettings.class).set(cfgMap);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        Assertions.assertEquals((Object)"Error evaluating value for setting 'test.setting.integer'. Setting 'test.setting.integer' can not have value 'not an int'. Should be of type 'Integer', but is 'String'", (Object)exception.getMessage());
    }

    @Test
    void testDoesNotLogChangedJvmArgs() throws IOException {
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), List.of("dbms.jvm.additional=-XX:+UseG1GC", "dbms.jvm.additional=-XX:+AlwaysPreTouch", "dbms.jvm.additional=-XX:+UnlockExperimentalVMOptions", "dbms.jvm.additional=-XX:+TrustFinalNonStaticFields"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        logProvider.assertNoLoggingOccurred();
    }

    private void tryRemoveReadPermissions(File file) {
        Assumptions.assumeTrue((boolean)file.setReadable(false));
        Assumptions.assumeFalse((boolean)file.canRead());
    }

    private static final class DependencySettings
    implements SettingsDeclaration {
        static final Setting<Path> basePath = SettingImpl.newBuilder((String)"test.base.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("/base/", new String[0]).toAbsolutePath()).immutable().build();
        static final Setting<Path> midPath = SettingImpl.newBuilder((String)"test.mid.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("mid/", new String[0])).setDependency(basePath).immutable().build();
        static final Setting<Path> endPath = SettingImpl.newBuilder((String)"test.end.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("end/file", new String[0])).setDependency(midPath).build();
        static final Setting<Path> absolute = SettingImpl.newBuilder((String)"test.absolute.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("/another/path/file", new String[0]).toAbsolutePath()).setDependency(midPath).build();
        private static final SettingValueParser<String> DefaultParser = new SettingValueParser<String>(){

            public String parse(String value) {
                return value;
            }

            public String getDescription() {
                return "";
            }

            public Class<String> getType() {
                return String.class;
            }
        };
        static final Setting<String> baseString = SettingImpl.newBuilder((String)"test.default.dependency.base", DefaultParser, (Object)"base").immutable().build();
        static final Setting<String> dependingString = SettingImpl.newBuilder((String)"test.default.dependency.dep", DefaultParser, null).setDependency(baseString).build();

        private DependencySettings() {
        }
    }

    static class ChildGroup
    extends ParentGroup {
        final Setting<String> childSetting = this.getBuilder("child", SettingValueParsers.STRING, null).build();

        private ChildGroup(String name) {
            super(name);
        }

        public String getPrefix() {
            return "test.inheritance";
        }
    }

    static abstract class ParentGroup
    extends GroupSetting {
        final Setting<String> parentSetting = this.getBuilder("parent", SettingValueParsers.STRING, "parent").build();

        ParentGroup(String name) {
            super(name);
        }
    }

    static class InvalidValidator
    implements GroupSettingValidator {
        InvalidValidator(Object invalidConstructor) {
        }

        public String getPrefix() {
            return "test.validator";
        }

        public String getDescription() {
            return null;
        }

        public void validate(Map<Setting<?>, Object> values, Config config) {
        }
    }

    public static class TestConnectionGroupSetting
    extends GroupSetting
    implements GroupSettingValidator {
        public final Setting<Integer> port = this.getBuilder("port", SettingValueParsers.INT, 1).build();
        public final Setting<String> hostname = this.getBuilder("hostname", SettingValueParsers.STRING, "0.0.0.0").build();
        public final Setting<Boolean> secure = this.getBuilder("secure", SettingValueParsers.BOOL, true).build();

        public static TestConnectionGroupSetting group(String name) {
            return new TestConnectionGroupSetting(name);
        }

        public String getPrefix() {
            return "test.connection.http";
        }

        TestConnectionGroupSetting(String id) {
            super(id);
        }

        public void validate(Map<Setting<?>, Object> values, Config config) {
            HashSet ports = new HashSet();
            values.forEach((S, V) -> {
                if (((SettingImpl)S).suffix().equals("port") && !ports.add((Integer)V)) {
                    throw new IllegalArgumentException("Need unique ports");
                }
            });
        }

        public String getDescription() {
            return "With unique ports";
        }
    }

    private static final class TestSettings
    implements SettingsDeclaration {
        static final Setting<String> stringSetting = SettingImpl.newBuilder((String)"test.setting.string", (SettingValueParser)SettingValueParsers.STRING, (Object)"hello").build();
        static final Setting<Integer> intSetting = SettingImpl.newBuilder((String)"test.setting.integer", (SettingValueParser)SettingValueParsers.INT, (Object)1).dynamic().build();
        static final Setting<List<Integer>> intListSetting = SettingImpl.newBuilder((String)"test.setting.integerlist", (SettingValueParser)SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.INT), List.of(Integer.valueOf(1))).build();
        static final Setting<Boolean> boolSetting = SettingImpl.newBuilder((String)"test.setting.bool", (SettingValueParser)SettingValueParsers.BOOL, null).immutable().build();

        private TestSettings() {
        }
    }

    private static final class SingleSettingGroup
    extends GroupSetting {
        final Setting<String> singleSetting = this.getBuilder(SettingValueParsers.STRING, null).build();

        static SingleSettingGroup group(String name) {
            return new SingleSettingGroup(name);
        }

        private SingleSettingGroup(String name) {
            super(name);
        }

        public String getPrefix() {
            return "test.single_setting";
        }
    }

    private static final class BrokenDependencySettings
    implements SettingsDeclaration {
        static final Setting<Path> broken = SettingImpl.newBuilder((String)"test.base.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("/base/", new String[0])).setDependency(SettingImpl.newBuilder((String)"test.not.present.dependency", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("/broken/", new String[0])).immutable().build()).immutable().build();

        private BrokenDependencySettings() {
        }
    }
}

