/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.string.SecureString;

class SettingTest {
    SettingTest() {
    }

    @Test
    void testSuffix() {
        SettingImpl setting1 = SettingTest.setting("setting", SettingValueParsers.INT);
        Assertions.assertEquals((Object)"setting", (Object)setting1.suffix());
        SettingImpl setting2 = SettingTest.setting("setting.suffix", SettingValueParsers.INT);
        Assertions.assertEquals((Object)"suffix", (Object)setting2.suffix());
        SettingImpl setting3 = SettingTest.setting("", SettingValueParsers.INT);
        Assertions.assertEquals((Object)"", (Object)setting3.suffix());
        SettingImpl setting4 = SettingTest.setting(null, SettingValueParsers.INT);
        Assertions.assertNull((Object)setting4.suffix());
    }

    @Test
    void testInteger() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.INT);
        Assertions.assertEquals((int)5, (Integer)((Integer)setting.parse("5")));
        Assertions.assertEquals((int)-76, (Integer)((Integer)setting.parse("-76")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
    }

    @Test
    void testLong() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.LONG);
        Assertions.assertEquals((long)112233445566778899L, (Long)((Long)setting.parse("112233445566778899")));
        Assertions.assertEquals((long)-112233445566778899L, (Long)((Long)setting.parse("-112233445566778899")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
    }

    @Test
    void testString() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.STRING);
        Assertions.assertEquals((Object)"foo", (Object)setting.parse("foo"));
        Assertions.assertEquals((Object)"bar", (Object)setting.parse("  bar   "));
    }

    @Test
    void testSecureString() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.SECURE_STRING);
        Assertions.assertEquals((Object)"foo", (Object)((SecureString)setting.parse("foo")).getString());
        Assertions.assertNotEquals((Object)"foo", (Object)((SecureString)setting.parse("foo")).toString());
        Assertions.assertEquals((Object)"bar", (Object)((SecureString)setting.parse("  bar   ")).getString());
        Assertions.assertNotEquals((Object)"foo", (Object)setting.valueToString((Object)((SecureString)setting.parse("foo"))));
    }

    @Test
    void testDouble() {
        BiFunction<Double, Double, Boolean> compareDoubles = (d1, d2) -> Math.abs(d1 - d2) < 1.0E-6;
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.DOUBLE);
        Assertions.assertEquals((double)5.0, (Double)((Double)setting.parse("5")));
        Assertions.assertTrue((boolean)compareDoubles.apply(-0.123, (Double)setting.parse("-0.123")));
        Assertions.assertTrue((boolean)compareDoubles.apply(5.0, (Double)setting.parse("5")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
    }

    @Test
    void testList() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.INT));
        Assertions.assertEquals((int)5, (Integer)((Integer)((List)setting.parse("5")).get(0)));
        Assertions.assertEquals((int)0, (int)((List)setting.parse("")).size());
        Assertions.assertEquals((int)4, (int)((List)setting.parse("5, 31, -4  ,2")).size());
        Assertions.assertEquals(Arrays.asList(4, 2, 3, 1), (Object)setting.parse("4,2,3,1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("2,3,foo,7"));
        Assertions.assertFalse((boolean)setting.valueToString((Object)((List)setting.parse("4,2,3,1"))).startsWith("["));
        Assertions.assertFalse((boolean)setting.valueToString((Object)((List)setting.parse("4,2,3,1"))).endsWith("]"));
    }

    @Test
    void testEnum() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.ofEnum(Colors.class));
        Assertions.assertEquals((Object)((Object)Colors.BLUE), (Object)setting.parse("BLUE"));
        Assertions.assertEquals((Object)((Object)Colors.GREEN), (Object)setting.parse("gReEn"));
        Assertions.assertEquals((Object)((Object)Colors.RED), (Object)setting.parse("red"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("orange"));
    }

    @Test
    void testPartialEnum() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.ofPartialEnum((Enum[])new Colors[]{Colors.GREEN, Colors.BLUE}));
        Assertions.assertEquals((Object)((Object)Colors.BLUE), (Object)setting.parse("BLUE"));
        Assertions.assertEquals((Object)((Object)Colors.GREEN), (Object)setting.parse("gReEn"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("red"));
    }

    @Test
    void testStringEnum() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.ofEnum(StringEnum.class));
        Assertions.assertEquals((Object)((Object)StringEnum.DEFAULT), (Object)setting.parse("default"));
        Assertions.assertEquals((Object)((Object)StringEnum.V_1), (Object)setting.parse("1.0"));
        Assertions.assertEquals((Object)((Object)StringEnum.V_1_1), (Object)setting.parse("1.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("orange"));
    }

    @Test
    void testBool() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.BOOL);
        Assertions.assertEquals((Object)true, (Object)setting.parse("True"));
        Assertions.assertEquals((Object)false, (Object)setting.parse("false"));
        Assertions.assertEquals((Object)false, (Object)setting.parse("false"));
        Assertions.assertEquals((Object)false, (Object)setting.parse("false"));
        Assertions.assertEquals((Object)true, (Object)setting.parse("true"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
    }

    @Test
    void testDuration() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.DURATION);
        Assertions.assertEquals((long)60L, (long)((Duration)setting.parse("1m")).toSeconds());
        Assertions.assertEquals((long)1000L, (long)((Duration)setting.parse("1s")).toMillis());
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
        Assertions.assertEquals((Object)"1s", (Object)setting.valueToString((Object)((Duration)setting.parse("1s"))));
        Assertions.assertEquals((Object)"3m", (Object)setting.valueToString((Object)((Duration)setting.parse("3m"))));
        Assertions.assertEquals((Object)"0ns", (Object)setting.valueToString((Object)((Duration)setting.parse("0s"))));
    }

    @Test
    void testHostnamePort() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.HOSTNAME_PORT);
        Assertions.assertEquals((Object)new HostnamePort("localhost", 7474), (Object)setting.parse("localhost:7474"));
        Assertions.assertEquals((Object)new HostnamePort("localhost", 1000, 2000), (Object)setting.parse("localhost:1000-2000"));
        Assertions.assertEquals((Object)new HostnamePort("localhost"), (Object)setting.parse("localhost"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("localhost:5641:7474"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("localhost:foo"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("7474:localhost"));
    }

    @Test
    void testTimeZone() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.TIMEZONE);
        Assertions.assertEquals((Object)ZoneId.from(ZoneOffset.UTC), (Object)setting.parse("+00:00"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("foo"));
    }

    @Test
    void testSocket() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.SOCKET_ADDRESS);
        Assertions.assertEquals((Object)new SocketAddress("127.0.0.1", 7474), (Object)setting.parse("127.0.0.1:7474"));
        Assertions.assertEquals((Object)new SocketAddress("127.0.0.1", -1), (Object)setting.parse("127.0.0.1"));
        Assertions.assertEquals((Object)new SocketAddress(null, 7474), (Object)setting.parse(":7474"));
    }

    @Test
    void testSocketSolve() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.SOCKET_ADDRESS);
        Assertions.assertEquals((Object)new SocketAddress("localhost", 7473), (Object)setting.solveDependency((Object)((SocketAddress)setting.parse("localhost:7473")), (Object)((SocketAddress)setting.parse("127.0.0.1:7474"))));
        Assertions.assertEquals((Object)new SocketAddress("127.0.0.1", 7473), (Object)setting.solveDependency((Object)((SocketAddress)setting.parse(":7473")), (Object)((SocketAddress)setting.parse("127.0.0.1:7474"))));
        Assertions.assertEquals((Object)new SocketAddress("127.0.0.1", 7473), (Object)setting.solveDependency((Object)((SocketAddress)setting.parse(":7473")), (Object)((SocketAddress)setting.parse("127.0.0.1"))));
        Assertions.assertEquals((Object)new SocketAddress("localhost", 7474), (Object)setting.solveDependency((Object)((SocketAddress)setting.parse("localhost")), (Object)((SocketAddress)setting.parse(":7474"))));
        Assertions.assertEquals((Object)new SocketAddress("localhost", 7474), (Object)setting.solveDependency((Object)((SocketAddress)setting.parse("localhost")), (Object)((SocketAddress)setting.parse("127.0.0.1:7474"))));
        Assertions.assertEquals((Object)new SocketAddress("localhost", 7474), (Object)setting.solveDependency(null, (Object)((SocketAddress)setting.parse("localhost:7474"))));
    }

    @Test
    void testBytes() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.BYTES);
        Assertions.assertEquals((long)2048L, (Long)((Long)setting.parse("2k")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("1gig"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.parse("-1M"));
    }

    @Test
    void testURI() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.URI);
        Assertions.assertEquals((Object)URI.create("/path/to/../something/"), (Object)setting.parse("/path/to/../something/"));
    }

    @Test
    void testNormalizedRelativeURI() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.NORMALIZED_RELATIVE_URI);
        Assertions.assertEquals((Object)URI.create("/path/to/something"), (Object)setting.parse("/path/away/from/../../to/something/"));
    }

    @Test
    void testPath() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.PATH);
        Assertions.assertEquals((Object)Path.of("/absolute/path", new String[0]), (Object)setting.parse("/absolute/path"));
        Assertions.assertEquals((Object)Path.of("/absolute/path", new String[0]), (Object)setting.parse("/absolute/wrong/../path"));
    }

    @Test
    void testSolvePath() {
        SettingImpl setting = SettingTest.setting("setting", SettingValueParsers.PATH);
        Assertions.assertEquals((Object)Path.of("/base/path/to/file", new String[0]).toAbsolutePath(), (Object)setting.solveDependency((Object)((Path)setting.parse("to/file")), (Object)((Path)setting.parse("/base/path")).toAbsolutePath()));
        Assertions.assertEquals((Object)Path.of("/to/file", new String[0]).toAbsolutePath(), (Object)setting.solveDependency((Object)((Path)setting.parse("/to/file")), (Object)((Path)setting.parse("/base/path")).toAbsolutePath()));
        Assertions.assertEquals((Object)Path.of("/base/path/", new String[0]).toAbsolutePath(), (Object)setting.solveDependency((Object)((Path)setting.parse("")), (Object)((Path)setting.parse("/base/path/")).toAbsolutePath()));
        Assertions.assertEquals((Object)Path.of("/base/path", new String[0]).toAbsolutePath(), (Object)setting.solveDependency((Object)((Path)setting.parse("path")), (Object)((Path)setting.parse("/base")).toAbsolutePath()));
        Assertions.assertEquals((Object)Path.of("/base", new String[0]).toAbsolutePath(), (Object)setting.solveDependency(null, (Object)((Path)setting.parse("/base")).toAbsolutePath()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.solveDependency((Object)((Path)setting.parse("path")), (Object)((Path)setting.parse("base"))));
    }

    @Test
    void testDefaultSolve() {
        SettingValueParser<String> defaultSolver = new SettingValueParser<String>(){

            public String parse(String value) {
                return value;
            }

            public String getDescription() {
                return "default solver";
            }

            public Class<String> getType() {
                return String.class;
            }
        };
        SettingImpl<String> setting = SettingTest.setting("setting", defaultSolver);
        Assertions.assertEquals((Object)"foo", (Object)setting.solveDependency((Object)"foo", (Object)"bar"));
        Assertions.assertEquals((Object)"bar", (Object)setting.solveDependency(null, (Object)"bar"));
        Assertions.assertEquals((Object)"foo", (Object)setting.solveDependency((Object)"foo", null));
        Assertions.assertNull((Object)setting.solveDependency(null, null));
    }

    @Test
    void testMinConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.INT).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(10))).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)100));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)9));
    }

    @Test
    void testMaxConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.INT).addConstraint(SettingConstraints.max((Comparable)Integer.valueOf(10))).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)-100));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)11));
    }

    @Test
    void testRangeConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.DOUBLE).addConstraint(SettingConstraints.range((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0))).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)9.9));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)20.01));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)10.1));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)19.9999));
    }

    @Test
    void testExceptConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.STRING).addConstraint(SettingConstraints.except((String[])new String[]{"foo"})).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)"foo"));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)"bar"));
    }

    @Test
    void testMatchesConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.STRING).addConstraint(SettingConstraints.matches((String)"^[^.]+\\.[^.]+$")).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)"foo.bar"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)"foo"));
    }

    @Test
    void testPowerOf2Constraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.LONG).addConstraint(SettingConstraints.POWER_OF_2).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)8L));
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)0x100000000L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)1023L));
    }

    @Test
    void testPortConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.INT).addConstraint(SettingConstraints.PORT).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)7474));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)200000));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)-1));
    }

    @Test
    void testIsConstraint() {
        SettingImpl setting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.INT).addConstraint(SettingConstraints.is((Object)10)).build();
        Assertions.assertDoesNotThrow(() -> setting.validate((Object)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> setting.validate((Object)9));
    }

    @Test
    void testAnyConstraint() {
        SettingImpl intSetting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.INT).addConstraint(SettingConstraints.any((SettingConstraint)SettingConstraints.min((Comparable)Integer.valueOf(30)), (SettingConstraint[])new SettingConstraint[]{SettingConstraints.is((Object)0), SettingConstraints.is((Object)-10)})).build();
        Assertions.assertDoesNotThrow(() -> intSetting.validate((Object)30));
        Assertions.assertDoesNotThrow(() -> intSetting.validate((Object)100));
        Assertions.assertDoesNotThrow(() -> intSetting.validate((Object)0));
        Assertions.assertDoesNotThrow(() -> intSetting.validate((Object)-10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> intSetting.validate((Object)29));
        Assertions.assertThrows(IllegalArgumentException.class, () -> intSetting.validate((Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> intSetting.validate((Object)-9));
        SettingImpl durationSetting = (SettingImpl)SettingTest.settingBuilder("setting", SettingValueParsers.DURATION).addConstraint(SettingConstraints.any((SettingConstraint)SettingConstraints.min((Comparable)Duration.ofMinutes(30L)), (SettingConstraint[])new SettingConstraint[]{SettingConstraints.is((Object)Duration.ZERO)})).build();
        Assertions.assertDoesNotThrow(() -> durationSetting.validate((Object)Duration.ofMinutes(30L)));
        Assertions.assertDoesNotThrow(() -> durationSetting.validate((Object)Duration.ofHours(1L)));
        Assertions.assertDoesNotThrow(() -> durationSetting.validate((Object)Duration.ZERO));
        Assertions.assertThrows(IllegalArgumentException.class, () -> durationSetting.validate((Object)Duration.ofMinutes(29L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> durationSetting.validate((Object)Duration.ofMillis(1L)));
    }

    @Test
    void testDescriptionWithConstraints() {
        SettingImpl oneConstraintSetting = (SettingImpl)SettingTest.settingBuilder("setting.name", SettingValueParsers.LONG).addConstraint(SettingConstraints.POWER_OF_2).build();
        SettingImpl twoConstraintSetting = (SettingImpl)SettingTest.settingBuilder("setting.name", SettingValueParsers.INT).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(2))).addConstraint(SettingConstraints.max((Comparable)Integer.valueOf(10))).build();
        Assertions.assertEquals((Object)"setting.name, a long which is power of 2", (Object)oneConstraintSetting.description());
        Assertions.assertEquals((Object)"setting.name, an integer which is minimum `2` and is maximum `10`", (Object)twoConstraintSetting.description());
    }

    @TestFactory
    Collection<DynamicTest> testDescriptionDependency() {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        tests.add(DynamicTest.dynamicTest((String)"Test int dependency description", () -> SettingTest.testDescDependency(SettingValueParsers.INT, "setting.child, an integer. If unset the value is inherited from setting.parent")));
        tests.add(DynamicTest.dynamicTest((String)"Test socket dependency description", () -> SettingTest.testDescDependency(SettingValueParsers.SOCKET_ADDRESS, "setting.child, a socket address. If missing port or hostname it is acquired from setting.parent")));
        tests.add(DynamicTest.dynamicTest((String)"Test path dependency description", () -> SettingTest.testDescDependency(SettingValueParsers.PATH, "setting.child, a path. If relative it is resolved from setting.parent")));
        return tests;
    }

    private static <T> void testDescDependency(SettingValueParser<T> parser, String expectedDescription) {
        Setting parent = SettingTest.settingBuilder("setting.parent", parser).immutable().build();
        Setting child = SettingTest.settingBuilder("setting.child", parser).setDependency(parent).build();
        Assertions.assertEquals((Object)expectedDescription, (Object)child.description());
    }

    private static <T> SettingImpl.Builder<T> settingBuilder(String name, SettingValueParser<T> parser) {
        return SettingImpl.newBuilder((String)name, parser, null);
    }

    private static <T> SettingImpl<T> setting(String name, SettingValueParser<T> parser) {
        return (SettingImpl)SettingImpl.newBuilder((String)name, parser, null).build();
    }

    private static enum StringEnum {
        DEFAULT("default"),
        V_1("1.0"),
        V_1_1("1.1");

        private final String name;

        private StringEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum Colors {
        BLUE,
        GREEN,
        RED;

    }
}

