/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.net.InetSocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;

class ConnectorPortRegisterTest {
    private final ConnectorPortRegister portRegister = new ConnectorPortRegister();

    ConnectorPortRegisterTest() {
    }

    @Test
    void shouldRegisterInetSocketAddress() {
        InetSocketAddress address = new InetSocketAddress(0);
        this.portRegister.register("key", address);
        this.verifyAddress("key", address.getHostString(), address.getPort());
    }

    @Test
    void shouldRegisterSocketAddress() {
        SocketAddress address = new SocketAddress("neo4j.com", 12345);
        this.portRegister.register("key", address);
        this.verifyAddress("key", address.getHostname(), address.getPort());
    }

    @Test
    void shouldDeregister() {
        SocketAddress address = new SocketAddress("neo4j.com", 42);
        this.portRegister.register("key", address);
        Assertions.assertNotNull((Object)this.portRegister.getLocalAddress("key"));
        this.portRegister.deregister("key");
        Assertions.assertNull((Object)this.portRegister.getLocalAddress("key"));
    }

    @Test
    void shouldReturnAddressByKey() {
        SocketAddress address1 = new SocketAddress("localhost", 7574);
        SocketAddress address2 = new SocketAddress("neo4j.com", 8989);
        SocketAddress address3 = new SocketAddress("8.8.8.8", 80);
        this.portRegister.register("key1", address1);
        this.portRegister.register("key2", address2);
        this.portRegister.register("key3", address3);
        this.verifyAddress("key1", "localhost", 7574);
        this.verifyAddress("key2", "neo4j.com", 8989);
        this.verifyAddress("key3", "8.8.8.8", 80);
    }

    private void verifyAddress(String key, String expectedHostname, int expectedPort) {
        HostnamePort expectedAddress = new HostnamePort(expectedHostname, expectedPort);
        Assertions.assertEquals((Object)expectedAddress, (Object)this.portRegister.getLocalAddress(key));
    }
}

