/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;

class DatabaseNameValidatorTest {
    DatabaseNameValidatorTest() {
    }

    @Test
    void shouldNotGetAnErrorForAValidDatabaseName() {
        this.assertValid("my.Vaild-Db123");
    }

    @Test
    void shouldGetAnErrorForAnEmptyDatabaseName() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid(""));
        Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> DatabaseNameValidator.assertValidDatabaseName(null));
        Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e2.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithInvalidCharacters() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("database%"));
        Assertions.assertEquals((Object)"Database name 'database%' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("data_base"));
        Assertions.assertEquals((Object)"Database name 'data_base' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e2.getMessage());
        Exception e3 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("data\u00e5\u00e4\u00f6"));
        Assertions.assertEquals((Object)"Database name 'data\u00e5\u00e4\u00f6' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e3.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithInvalidFirstCharacter() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("3database"));
        Assertions.assertEquals((Object)"Database name '3database' is not starting with an ASCII alphabetic character.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("_database"));
        Assertions.assertEquals((Object)"Database name '_database' is not starting with an ASCII alphabetic character.", (Object)e2.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithSystemPrefix() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("systemdatabase"));
        Assertions.assertEquals((Object)"Database name 'systemdatabase' is invalid, due to the prefix 'system'.", (Object)e.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithInvalidLength() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("me"));
        Assertions.assertEquals((Object)"The provided database name must have a length between 3 and 63 characters.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertValid("ihaveallooootoflettersclearlymorethenishould-ihaveallooootoflettersclearlymorethenishould"));
        Assertions.assertEquals((Object)"The provided database name must have a length between 3 and 63 characters.", (Object)e2.getMessage());
    }

    private void assertValid(String name) {
        DatabaseNameValidator.assertValidDatabaseName((NormalizedDatabaseName)new NormalizedDatabaseName(name));
    }
}

