/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.GraphNameValidator;
import org.neo4j.configuration.helpers.NormalizedGraphName;

class GraphNameValidatorTest {
    GraphNameValidatorTest() {
    }

    @Test
    void shouldNotGetAnErrorForAValidGraphName() {
        this.checkGraphName("my.Vaild-Db123");
    }

    @Test
    void shouldGetAnErrorForAnEmptyGraphName() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName(""));
        Assertions.assertEquals((Object)"The provided graph name is empty.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> GraphNameValidator.assertValidGraphName(null));
        Assertions.assertEquals((Object)"The provided graph name is empty.", (Object)e2.getMessage());
    }

    @Test
    void shouldGetAnErrorForAGraphNameWithInvalidCharacters() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("graph%"));
        Assertions.assertEquals((Object)"Graph name 'graph%' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("data_base"));
        Assertions.assertEquals((Object)"Graph name 'data_base' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e2.getMessage());
        Exception e3 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("data\u00e5\u00e4\u00f6"));
        Assertions.assertEquals((Object)"Graph name 'data\u00e5\u00e4\u00f6' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.", (Object)e3.getMessage());
    }

    @Test
    void shouldGetAnErrorForAGraphNameWithInvalidFirstCharacter() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("3graph"));
        Assertions.assertEquals((Object)"Graph name '3graph' is not starting with an ASCII alphabetic character.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("_graph"));
        Assertions.assertEquals((Object)"Graph name '_graph' is not starting with an ASCII alphabetic character.", (Object)e2.getMessage());
    }

    @Test
    void shouldGetAnErrorForAGraphNamedGraph() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("graph"));
        Assertions.assertEquals((Object)"Graph name 'graph' is reserved.", (Object)e.getMessage());
    }

    @Test
    void shouldGetAnErrorForAGraphNameWithInvalidLength() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("me"));
        Assertions.assertEquals((Object)"The provided graph name must have a length between 3 and 63 characters.", (Object)e.getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkGraphName("ihaveallooootoflettersclearlymorethenishould-ihaveallooootoflettersclearlymorethenishould"));
        Assertions.assertEquals((Object)"The provided graph name must have a length between 3 and 63 characters.", (Object)e2.getMessage());
    }

    private void checkGraphName(String name) {
        GraphNameValidator.assertValidGraphName((NormalizedGraphName)new NormalizedGraphName(name));
    }
}

