/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.string.SecureString;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class SslPolicyConfigValidatorTest {
    @Inject
    private TestDirectory testDirectory;

    SslPolicyConfigValidatorTest() {
    }

    @Test
    void shouldFindPolicyDefaults() {
        SslPolicyConfig policyConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        File homeDir = this.testDirectory.directory("home", new String[0]);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toPath().toAbsolutePath()).set(policyConfig.base_directory, (Object)Path.of("certificates/testing", new String[0])).build();
        File privateKey = new File(homeDir, "certificates/testing/private.key");
        File publicCertificate = new File(homeDir, "certificates/testing/public.crt");
        File trustedDir = new File(homeDir, "certificates/testing/trusted");
        File revokedDir = new File(homeDir, "certificates/testing/revoked");
        File privateKeyFromConfig = ((Path)config.get(policyConfig.private_key)).toFile();
        File publicCertificateFromConfig = ((Path)config.get(policyConfig.public_certificate)).toFile();
        File trustedDirFromConfig = ((Path)config.get(policyConfig.trusted_dir)).toFile();
        File revokedDirFromConfig = ((Path)config.get(policyConfig.revoked_dir)).toFile();
        SecureString privateKeyPassword = (SecureString)config.get(policyConfig.private_key_password);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        Assertions.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assertions.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assertions.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assertions.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assertions.assertNull((Object)privateKeyPassword);
        Assertions.assertFalse((boolean)trustAll);
        Assertions.assertEquals(Collections.singletonList("TLSv1.2"), (Object)tlsVersions);
        Assertions.assertNull((Object)ciphers);
        Assertions.assertEquals((Object)ClientAuth.REQUIRE, (Object)clientAuth);
    }

    @Test
    void shouldFindPolicyOverrides() {
        Config.Builder builder = Config.newBuilder();
        SslPolicyConfig policyConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        File homeDir = this.testDirectory.directory("home", new String[0]);
        builder.set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toPath().toAbsolutePath());
        builder.set(policyConfig.base_directory, (Object)Path.of("certificates/testing", new String[0]));
        File privateKey = this.testDirectory.directory("/path/to/my.key", new String[0]);
        File publicCertificate = this.testDirectory.directory("/path/to/my.crt", new String[0]);
        File trustedDir = this.testDirectory.directory("/some/other/path/to/trusted", new String[0]);
        File revokedDir = this.testDirectory.directory("/some/other/path/to/revoked", new String[0]);
        builder.set(policyConfig.private_key, (Object)privateKey.toPath().toAbsolutePath());
        builder.set(policyConfig.public_certificate, (Object)publicCertificate.toPath().toAbsolutePath());
        builder.set(policyConfig.trusted_dir, (Object)trustedDir.toPath().toAbsolutePath());
        builder.set(policyConfig.revoked_dir, (Object)revokedDir.toPath().toAbsolutePath());
        builder.set(policyConfig.trust_all, (Object)true);
        builder.set(policyConfig.private_key_password, (Object)new SecureString("setecastronomy"));
        builder.set(policyConfig.tls_versions, List.of("TLSv1.1", "TLSv1.2"));
        builder.set(policyConfig.ciphers, List.of("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"));
        builder.set(policyConfig.client_auth, (Object)ClientAuth.OPTIONAL);
        Config config = builder.build();
        File privateKeyFromConfig = ((Path)config.get(policyConfig.private_key)).toFile();
        File publicCertificateFromConfig = ((Path)config.get(policyConfig.public_certificate)).toFile();
        File trustedDirFromConfig = ((Path)config.get(policyConfig.trusted_dir)).toFile();
        File revokedDirFromConfig = ((Path)config.get(policyConfig.revoked_dir)).toFile();
        SecureString privateKeyPassword = (SecureString)config.get(policyConfig.private_key_password);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        Assertions.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assertions.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assertions.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assertions.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assertions.assertTrue((boolean)trustAll);
        Assertions.assertEquals((Object)"setecastronomy", (Object)privateKeyPassword.getString());
        Assertions.assertEquals(Arrays.asList("TLSv1.1", "TLSv1.2"), (Object)tlsVersions);
        Assertions.assertEquals(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"), (Object)ciphers);
        Assertions.assertEquals((Object)ClientAuth.OPTIONAL, (Object)clientAuth);
    }

    @Test
    void shouldAcceptAllValidPemPolicyKeys() {
        SslPolicyConfig sslPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        Config.Builder builder = Config.newBuilder().set(sslPolicy.base_directory, (Object)Path.of("xyz", new String[0])).set(sslPolicy.revoked_dir, (Object)Path.of("xyz", new String[0])).set(sslPolicy.trust_all, (Object)false).set(sslPolicy.client_auth, (Object)ClientAuth.NONE).set(sslPolicy.tls_versions, List.of("xyz")).set(sslPolicy.ciphers, List.of("xyz")).set(sslPolicy.verify_hostname, (Object)true).set(sslPolicy.private_key, (Object)Path.of("xyz", new String[0])).set(sslPolicy.public_certificate, (Object)Path.of("xyz", new String[0])).set(sslPolicy.trusted_dir, (Object)Path.of("xyz", new String[0])).set(sslPolicy.private_key_password, (Object)new SecureString("xyz"));
        Assertions.assertDoesNotThrow(() -> ((Config.Builder)builder).build());
    }

    @Test
    void shouldThrowOnUnknownPolicySetting() throws IOException {
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), Arrays.asList("dbms.ssl.policy.testing.trust_all=xyz", "dbms.ssl.policy.testing.color=blue"), new OpenOption[0]);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().fromFile(confFile).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Error evaluating value for setting"));
    }

    @Test
    void shouldThrowOnDirectPolicySetting() throws IOException {
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), Arrays.asList("dbms.ssl.policy.base_directory.trust_all=xyz", "dbms.ssl.policy.base_directory=path"), new OpenOption[0]);
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).fromFile(confFile);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"No declared setting with name: dbms.ssl.policy."));
    }

    @Test
    void shouldIgnoreUnknownNonPolicySettings() throws IOException {
        File confFile = this.testDirectory.createFile("test.conf", new String[0]);
        Files.write(confFile.toPath(), Arrays.asList("dbms.ssl.unknown=xyz", "dbms.ssl.something=xyz", "dbms.unrelated.totally=xyz"), new OpenOption[0]);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).fromFile(confFile).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Unrecognized setting"));
    }

    private static Map<String, String> params(String ... params) {
        return Collections.unmodifiableMap(MapUtil.stringMap((String[])params));
    }
}

