/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.SocketAddress;

class SettingConstraintsTest {
    SettingConstraintsTest() {
    }

    @Test
    void invalidAdvertisedAddress() {
        Assertions.assertThat((Throwable)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().set(GraphDatabaseSettings.default_advertised_address, (Object)new SocketAddress("0.0.00.000")).build()))).hasMessageContaining("advertised address cannot be '0.0.0.0'");
        Assertions.assertThat((Throwable)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().set(GraphDatabaseSettings.default_advertised_address, (Object)new SocketAddress("::")).build()))).hasMessageContaining("advertised address cannot be '::'");
    }

    @Test
    void invalidDefaultAddress() {
        Assertions.assertThat((Throwable)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().set(GraphDatabaseSettings.default_advertised_address, (Object)new SocketAddress("localhost", 1234)).build()))).hasMessageContaining("can not have a port");
    }

    @Test
    void validDefaultAdvertisedAddress() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> Config.newBuilder().set(GraphDatabaseSettings.default_advertised_address, (Object)new SocketAddress("localhost")).build());
    }
}

