/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class SettingMigratorsTest {
    @Inject
    private TestDirectory testDirectory;

    SettingMigratorsTest() {
    }

    @Test
    void testConnectorOldFormatMigration() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, Arrays.asList("dbms.connector.bolt.unsupported_thread_pool_shutdown_wait_time=1s", "dbms.connector.bolt.enabled=true", "dbms.connector.bolt.type=BOLT", "dbms.connector.http.enabled=true", "dbms.connector.https.enabled=true"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertTrue((boolean)((Boolean)config.get(BoltConnector.enabled)));
        Assertions.assertTrue((boolean)((Boolean)config.get(HttpConnector.enabled)));
        Assertions.assertTrue((boolean)((Boolean)config.get(HttpsConnector.enabled)));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)config.get(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time));
        LogAssert warnConfigMatcher = LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN);
        warnConfigMatcher.containsMessages(new String[]{"Use of deprecated setting 'dbms.connector.http.enabled'. It is replaced by 'server.http.enabled'."}).containsMessages(new String[]{"Use of deprecated setting 'dbms.connector.https.enabled'. It is replaced by 'server.https.enabled'."});
    }

    @Test
    void warnOnLegacyUnsupportedSettingUsage() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("unsupported.tools.batch_inserter.batch_size=42"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Use of deprecated setting 'unsupported.tools.batch_inserter.batch_size'. It is replaced by 'internal.tools.batch_inserter.batch_size'."});
    }

    @Test
    void testMemorySettingsRename() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.tx_state.max_off_heap_memory=6g", "dbms.tx_state.off_heap.max_cacheable_block_size=4096", "dbms.tx_state.off_heap.block_cache_size=256"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.tx_state.max_off_heap_memory", GraphDatabaseSettings.tx_state_max_off_heap_memory.name()}).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.tx_state.off_heap.max_cacheable_block_size", GraphDatabaseSettings.tx_state_off_heap_max_cacheable_block_size.name()}).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.tx_state.off_heap.block_cache_size", GraphDatabaseSettings.tx_state_off_heap_block_cache_size.name()});
        Assertions.assertEquals((Long)((Long)SettingValueParsers.BYTES.parse("6g")), (Long)((Long)config.get(GraphDatabaseSettings.tx_state_max_off_heap_memory)));
        Assertions.assertEquals((long)4096L, (Long)((Long)config.get(GraphDatabaseSettings.tx_state_off_heap_max_cacheable_block_size)));
        Assertions.assertEquals((int)256, (Integer)((Integer)config.get(GraphDatabaseSettings.tx_state_off_heap_block_cache_size)));
    }

    @Test
    void testLegacyOffHeapMemorySettingsRename() throws IOException {
        String legacySetting = "server.memory.off_heap.max_size";
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("server.memory.off_heap.max_size=6g"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"server.memory.off_heap.max_size", GraphDatabaseSettings.tx_state_max_off_heap_memory.name()});
        Assertions.assertEquals((Long)((Long)SettingValueParsers.BYTES.parse("6g")), (Long)((Long)config.get(GraphDatabaseSettings.tx_state_max_off_heap_memory)));
    }

    @Test
    void transactionCypherMaxAllocations() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("cypher.query_max_allocations=6g"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("The setting cypher.query_max_allocations is removed and replaced by %s.", new Object[]{GraphDatabaseSettings.memory_transaction_max_size.name()});
        Assertions.assertEquals((Long)((Long)SettingValueParsers.BYTES.parse("6g")), (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_max_size)));
    }

    @Test
    void transactionCypherMaxAllocationsConflict() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("cypher.query_max_allocations=6g", GraphDatabaseSettings.memory_transaction_max_size.name() + "=7g"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("The setting cypher.query_max_allocations is removed and replaced by %s. Since both are set, %s will take precedence and the value of cypher.query_max_allocations, %s, will be ignored.", new Object[]{GraphDatabaseSettings.memory_transaction_max_size.name(), GraphDatabaseSettings.memory_transaction_max_size.name(), "6g"});
        Assertions.assertEquals((Long)((Long)SettingValueParsers.BYTES.parse("7g")), (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_max_size)));
    }

    @Test
    void testWhitelistRename() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.memory.pagecache.warmup.preload.whitelist=a", "dbms.security.procedures.whitelist=a,b"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.memory.pagecache.warmup.preload.whitelist", GraphDatabaseSettings.pagecache_warmup_prefetch_allowlist.name()}).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.security.procedures.whitelist", GraphDatabaseSettings.procedure_allowlist.name()});
        Assertions.assertEquals((Object)"a", (Object)config.get(GraphDatabaseSettings.pagecache_warmup_prefetch_allowlist));
        Assertions.assertEquals(List.of("a", "b"), (Object)config.get(GraphDatabaseSettings.procedure_allowlist));
    }

    @Test
    void testDatababaseRename() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.memory.transaction.datababase_max_size=1g"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.memory.transaction.datababase_max_size", GraphDatabaseSettings.memory_transaction_database_max_size.name()});
        Assertions.assertEquals((long)0x40000000L, (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_database_max_size)));
    }

    @Test
    void windowsServiceNameMigration() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.windows_service_name=foo-bar"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((Object)"foo-bar", (Object)config.get(BootloaderSettings.windows_service_name));
    }

    @Test
    void checkpointSettingsMigration() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.checkpoint=PERIODIC", "dbms.checkpoint.interval.time=10m", "dbms.checkpoint.interval.tx=17", "dbms.checkpoint.interval.volume=125m", "dbms.checkpoint.iops.limit=456"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((Object)GraphDatabaseSettings.CheckpointPolicy.PERIODIC, (Object)config.get(GraphDatabaseSettings.check_point_policy));
        Assertions.assertEquals((Object)Duration.ofMinutes(10L), (Object)config.get(GraphDatabaseSettings.check_point_interval_time));
        Assertions.assertEquals((int)17, (Integer)((Integer)config.get(GraphDatabaseSettings.check_point_interval_tx)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)125L), (Long)((Long)config.get(GraphDatabaseSettings.check_point_interval_volume)));
        Assertions.assertEquals((int)456, (Integer)((Integer)config.get(GraphDatabaseSettings.check_point_iops_limit)));
    }

    @Test
    void directoriesSettingsMigration() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Path a = this.testDirectory.directory("a").toAbsolutePath();
        Path b = this.testDirectory.directory("b").toAbsolutePath();
        Path c = this.testDirectory.directory("c").toAbsolutePath();
        Path d = this.testDirectory.directory("d").toAbsolutePath();
        Path e = this.testDirectory.directory("e").toAbsolutePath();
        Path f = this.testDirectory.directory("f").toAbsolutePath();
        Path g = this.testDirectory.directory("g").toAbsolutePath();
        Path h = this.testDirectory.directory("h").toAbsolutePath();
        Path i = this.testDirectory.directory("i").toAbsolutePath();
        Path j = this.testDirectory.directory("j").toAbsolutePath();
        Path k = this.testDirectory.directory("k").toAbsolutePath();
        Files.write(confFile, List.of("dbms.directories.neo4j_home=" + FileSystemUtils.pathToString((Path)a), "dbms.directories.data=" + FileSystemUtils.pathToString((Path)b), "dbms.directories.transaction.logs.root=" + FileSystemUtils.pathToString((Path)c), "dbms.directories.script.root=" + FileSystemUtils.pathToString((Path)d), "dbms.directories.dumps.root=" + FileSystemUtils.pathToString((Path)e), "dbms.directories.import=" + FileSystemUtils.pathToString((Path)f), "dbms.directories.plugins=" + FileSystemUtils.pathToString((Path)g), "dbms.directories.logs=" + FileSystemUtils.pathToString((Path)h), "dbms.directories.licenses=" + FileSystemUtils.pathToString((Path)i), "dbms.directories.run=" + FileSystemUtils.pathToString((Path)j), "dbms.directories.lib=" + FileSystemUtils.pathToString((Path)k)), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((Object)a, (Object)config.get(GraphDatabaseSettings.neo4j_home));
        Assertions.assertEquals((Object)b, (Object)config.get(GraphDatabaseSettings.data_directory));
        Assertions.assertEquals((Object)c, (Object)config.get(GraphDatabaseSettings.transaction_logs_root_path));
        Assertions.assertEquals((Object)d, (Object)config.get(GraphDatabaseSettings.script_root_path));
        Assertions.assertEquals((Object)e, (Object)config.get(GraphDatabaseSettings.database_dumps_root_path));
        Assertions.assertEquals((Object)f, (Object)config.get(GraphDatabaseSettings.load_csv_file_url_root));
        Assertions.assertEquals((Object)g, (Object)config.get(GraphDatabaseSettings.plugin_dir));
        Assertions.assertEquals((Object)h, (Object)config.get(GraphDatabaseSettings.logs_directory));
        Assertions.assertEquals((Object)i, (Object)config.get(GraphDatabaseSettings.licenses_directory));
        Assertions.assertEquals((Object)j, (Object)config.get(BootloaderSettings.run_directory));
        Assertions.assertEquals((Object)k, (Object)config.get(BootloaderSettings.lib_directory));
    }

    @Test
    void readOnlySettingMigration() throws IOException {
        Path configuration = this.testDirectory.createFile("test.conf");
        Files.write(configuration, List.of("dbms.read_only=true"), new OpenOption[0]);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().fromFile(configuration).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((Boolean)((Boolean)config.get(GraphDatabaseSettings.read_only_database_default))).isTrue();
        LogAssertions.assertThat((Boolean)((Boolean)Config.defaults().get(GraphDatabaseSettings.read_only_database_default))).isFalse();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{String.format("Use of deprecated setting 'dbms.read_only'. It is replaced by '%s'", GraphDatabaseSettings.read_only_database_default.name())});
    }

    @Test
    void removedSettingMigration() throws IOException {
        Path configuration = this.testDirectory.createFile("test.conf");
        Files.write(configuration, List.of("dbms.allow_upgrade=false"), new OpenOption[0]);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().fromFile(configuration).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Setting 'dbms.allow_upgrade' is removed. It no longer has any effect."});
    }

    @Test
    void migrateCypherSettingsIntoDbmsNamespace() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("cypher.forbid_exhaustive_shortestpath=true", "cypher.forbid_shortestpath_common_nodes=false", "cypher.hints_error=true", "cypher.lenient_create_relationship=false", "cypher.min_replan_interval=11s", "cypher.planner=COST", "cypher.render_plan_description=true", "cypher.statistics_divergence_threshold=0.42"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((Object)true, (Object)config.get(GraphDatabaseSettings.forbid_exhaustive_shortestpath));
        Assertions.assertEquals((Object)false, (Object)config.get(GraphDatabaseSettings.forbid_shortestpath_common_nodes));
        Assertions.assertEquals((Object)true, (Object)config.get(GraphDatabaseSettings.cypher_hints_error));
        Assertions.assertEquals((Object)false, (Object)config.get(GraphDatabaseSettings.cypher_lenient_create_relationship));
        Assertions.assertEquals((Object)Duration.ofSeconds(11L), (Object)config.get(GraphDatabaseSettings.cypher_min_replan_interval));
        Assertions.assertEquals((Object)GraphDatabaseSettings.CypherPlanner.COST, (Object)config.get(GraphDatabaseSettings.cypher_planner));
        Assertions.assertEquals((Object)true, (Object)config.get(GraphDatabaseSettings.cypher_render_plan_descriptions));
        Assertions.assertEquals((double)0.42, (double)((Double)config.get(GraphDatabaseSettings.query_statistics_divergence_threshold)), (double)0.01);
    }

    @Test
    void migrateCypherQueryCacheSizeSetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("server.db.query_cache_size=100"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((int)100, (Integer)((Integer)config.get(GraphDatabaseSettings.query_cache_size)));
    }

    @Test
    void migrateTxLogsAndStateSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.tx_log.buffer.size=134072", "dbms.tx_log.preallocate=false", "dbms.tx_log.rotation.retention_policy=3 days", "dbms.tx_log.rotation.size=34mb", "dbms.tx_state.memory_allocation=ON_HEAP"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertEquals((long)ByteUnit.bytes((long)134072L), (Long)((Long)config.get(GraphDatabaseSettings.transaction_log_buffer_size)));
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.preallocate_logical_logs)));
        Assertions.assertEquals((Object)"3 days", (Object)config.get(GraphDatabaseSettings.keep_logical_logs));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)34L), (Long)((Long)config.get(GraphDatabaseSettings.logical_log_rotation_threshold)));
        Assertions.assertEquals((Object)GraphDatabaseSettings.TransactionStateMemoryAllocation.ON_HEAP, (Object)config.get(GraphDatabaseSettings.tx_state_memory_allocation));
    }

    @Test
    void migrateWatcherSetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.filewatcher.enabled=false"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.filewatcher_enabled)));
    }

    @Test
    void migrateLockAcquisitionSetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.lock.acquisition.timeout=15m"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((Object)Duration.ofMinutes(15L), (Object)config.get(GraphDatabaseSettings.lock_acquisition_timeout));
    }

    @Test
    void migrateCsvImportSetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.import.csv.buffer_size=123", "dbms.import.csv.legacy_quote_escaping=false"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((long)123L, (Long)((Long)config.get(GraphDatabaseSettings.csv_buffer_size)));
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.csv_legacy_quote_escaping)));
    }

    @Test
    void migrateTransactionAndMonitoringSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.track_query_cpu_time=true", "dbms.transaction.bookmark_ready_timeout=100s", "dbms.transaction.concurrent.maximum=17", "dbms.transaction.monitor.check.interval=4s", "dbms.transaction.sampling.percentage=78", "dbms.transaction.timeout=10s", "dbms.transaction.tracing.level=SAMPLE"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.track_query_cpu_time)));
        Assertions.assertEquals((Object)Duration.ofSeconds(100L), (Object)config.get(GraphDatabaseSettings.bookmark_ready_timeout));
        Assertions.assertEquals((int)17, (Integer)((Integer)config.get(GraphDatabaseSettings.max_concurrent_transactions)));
        Assertions.assertEquals((Object)Duration.ofSeconds(4L), (Object)config.get(GraphDatabaseSettings.transaction_monitor_check_interval));
        Assertions.assertEquals((int)78, (Integer)((Integer)config.get(GraphDatabaseSettings.transaction_sampling_percentage)));
        Assertions.assertEquals((Object)Duration.ofSeconds(10L), (Object)config.get(GraphDatabaseSettings.transaction_timeout));
        Assertions.assertEquals((Object)GraphDatabaseSettings.TransactionTracingLevel.SAMPLE, (Object)config.get(GraphDatabaseSettings.transaction_tracing_level));
    }

    @Test
    void migrateGcLogsSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.logs.gc.enabled=true", "dbms.logs.gc.options=niceOptions", "dbms.logs.gc.rotation.keep_number=7", "dbms.logs.gc.rotation.size=5m"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertTrue((boolean)((Boolean)config.get(BootloaderSettings.gc_logging_enabled)));
        Assertions.assertEquals((Object)"niceOptions", (Object)config.get(BootloaderSettings.gc_logging_options));
        Assertions.assertEquals((int)7, (Integer)((Integer)config.get(BootloaderSettings.gc_logging_rotation_keep_number)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)5L), (Long)((Long)config.get(BootloaderSettings.gc_logging_rotation_size)));
    }

    @Test
    void migrateProcessorNumberToInternalNamespace() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.upgrade_max_processors=7"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((int)7, (Integer)((Integer)config.get(GraphDatabaseInternalSettings.upgrade_processors)));
    }

    @Test
    void migratePageCacheWarmupSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.memory.pagecache.warmup.enable=true", "dbms.memory.pagecache.warmup.preload=false", "dbms.memory.pagecache.warmup.preload.allowlist=*index*", "dbms.memory.pagecache.warmup.profile.interval=5s"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.pagecache_warmup_enabled)));
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.pagecache_warmup_prefetch)));
        Assertions.assertEquals((Object)"*index*", (Object)config.get(GraphDatabaseSettings.pagecache_warmup_prefetch_allowlist));
        Assertions.assertEquals((Object)Duration.ofSeconds(5L), (Object)config.get(GraphDatabaseSettings.pagecache_warmup_profiling_interval));
    }

    @Test
    void migrateShutdownTimeoutAndPreallocations() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.shutdown_transaction_end_timeout=17m", "dbms.store.files.preallocate=false"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((Object)Duration.ofMinutes(17L), (Object)config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout));
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.preallocate_store_files)));
    }

    @Test
    void migrateQueryCacheSize() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.query_cache_size=132"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((int)132, (Integer)((Integer)config.get(GraphDatabaseSettings.query_cache_size)));
    }

    @Test
    void migrateTransactionMemorySettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.memory.transaction.database_max_size=11m", "dbms.memory.transaction.global_max_size=111m", "dbms.memory.transaction.max_size=1111m"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)11L), (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_database_max_size)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)111L), (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_global_max_size)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1111L), (Long)((Long)config.get(GraphDatabaseSettings.memory_transaction_max_size)));
    }

    @Test
    void migrateGroupAndRecoverySettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.relationship_grouping_threshold=4242", "dbms.recovery.fail_on_missing_files=true"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((int)4242, (Integer)((Integer)config.get(GraphDatabaseSettings.dense_node_threshold)));
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.fail_on_missing_files)));
    }

    @Test
    void migrateDefaultAddress() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.default_listen_address=localhost1", "dbms.default_advertised_address=otherhost"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((Object)new SocketAddress("localhost1"), (Object)config.get(GraphDatabaseSettings.default_listen_address));
        Assertions.assertEquals((Object)new SocketAddress("otherhost"), (Object)config.get(GraphDatabaseSettings.default_advertised_address));
    }

    @Test
    void migrateQueryLogsSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.logs.query.transaction.threshold=7d", "dbms.logs.query.transaction.enabled=INFO", "dbms.logs.query.threshold=8m", "dbms.logs.query.plan_description_enabled=true", "dbms.logs.query.parameter_logging_enabled=false", "dbms.logs.query.obfuscate_literals=true", "dbms.logs.query.max_parameter_length=9", "dbms.logs.query.enabled=VERBOSE", "dbms.logs.query.early_raw_logging_enabled=true"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((Object)Duration.ofDays(7L), (Object)config.get(GraphDatabaseSettings.log_queries_transaction_threshold));
        Assertions.assertEquals((Object)GraphDatabaseSettings.LogQueryLevel.INFO, (Object)config.get(GraphDatabaseSettings.log_queries_transactions_level));
        Assertions.assertEquals((Object)Duration.ofMinutes(8L), (Object)config.get(GraphDatabaseSettings.log_queries_threshold));
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.log_queries_query_plan)));
        Assertions.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.log_queries_parameter_logging_enabled)));
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.log_queries_obfuscate_literals)));
        Assertions.assertEquals((int)9, (Integer)((Integer)config.get(GraphDatabaseSettings.query_log_max_parameter_length)));
        Assertions.assertEquals((Object)GraphDatabaseSettings.LogQueryLevel.VERBOSE, (Object)config.get(GraphDatabaseSettings.log_queries));
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.log_queries_early_raw_logging_enabled)));
    }

    @Test
    void migrateJVMAdditional() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.jvm.additional=-XX:+UseG1GC", "dbms.jvm.additional=-XX:-OmitStackTraceInFastThrow", "dbms.jvm.additional=-XX:+TrustFinalNonStaticFields"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        LogAssertions.assertThat((String)((String)config.get(BootloaderSettings.additional_jvm))).isEqualToIgnoringNewLines((CharSequence)"-XX:+UseG1GC\n-XX:-OmitStackTraceInFastThrow\n-XX:+TrustFinalNonStaticFields");
    }

    @Test
    void migrateSamplingSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.index_sampling.background_enabled=true", "dbms.index_sampling.sample_size_limit=1048577", "dbms.index_sampling.update_percentage=75"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.index_background_sampling_enabled)));
        Assertions.assertEquals((int)0x100001, (Integer)((Integer)config.get(GraphDatabaseSettings.index_sample_size_limit)));
        Assertions.assertEquals((int)75, (Integer)((Integer)config.get(GraphDatabaseSettings.index_sampling_update_percentage)));
    }

    @Test
    void migratePageCacheAndMemorySettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.memory.pagecache.size=1G", "dbms.memory.pagecache.scan.prefetchers=8", "dbms.memory.pagecache.flush.buffer.size_in_pages=129", "dbms.memory.pagecache.flush.buffer.enabled=true", "dbms.memory.pagecache.directio=true", "dbms.memory.off_heap.max_size=4G", "dbms.memory.off_heap.max_cacheable_block_size=2M", "dbms.memory.off_heap.block_cache_size=124", "dbms.memory.heap.max_size=512M", "dbms.memory.heap.initial_size=511M"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((long)ByteUnit.gibiBytes((long)1L), (Long)((Long)config.get(GraphDatabaseSettings.pagecache_memory)));
        Assertions.assertEquals((int)8, (Integer)((Integer)config.get(GraphDatabaseSettings.pagecache_scan_prefetch)));
        Assertions.assertEquals((int)129, (Integer)((Integer)config.get(GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages)));
        Assertions.assertEquals((Object)true, (Object)config.get(GraphDatabaseSettings.pagecache_buffered_flush_enabled));
        Assertions.assertEquals((Object)true, (Object)config.get(GraphDatabaseSettings.pagecache_direct_io));
        Assertions.assertEquals((long)ByteUnit.gibiBytes((long)4L), (Long)((Long)config.get(GraphDatabaseSettings.tx_state_max_off_heap_memory)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)2L), (Long)((Long)config.get(GraphDatabaseSettings.tx_state_off_heap_max_cacheable_block_size)));
        Assertions.assertEquals((int)124, (Integer)((Integer)config.get(GraphDatabaseSettings.tx_state_off_heap_block_cache_size)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)512L), (Long)((Long)config.get(BootloaderSettings.max_heap_size)));
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)511L), (Long)((Long)config.get(BootloaderSettings.initial_heap_size)));
    }

    @Test
    void autoUpgradeMigrationWithBothSet() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().setRaw(Map.of("internal.dbms.allow_single_automatic_upgrade", "true", GraphDatabaseInternalSettings.automatic_upgrade_enabled.name(), "false")).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((Boolean)((Boolean)config.get(GraphDatabaseInternalSettings.automatic_upgrade_enabled))).isFalse();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Use of deprecated setting 'internal.dbms.allow_single_automatic_upgrade'. It is replaced by"});
    }

    @Test
    void autoUpgradeMigration() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().setRaw(Map.of("internal.dbms.allow_single_automatic_upgrade", "false")).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((Boolean)((Boolean)config.get(GraphDatabaseInternalSettings.automatic_upgrade_enabled))).isFalse();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Use of deprecated setting 'internal.dbms.allow_single_automatic_upgrade'. It is replaced by"});
    }

    @Test
    void annotationDataAsJson() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().setRaw(Map.of("db.logs.query.annotation_data_as_json_enabled", "true")).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((Comparable)((GraphDatabaseSettings.AnnotationDataFormat)config.get(GraphDatabaseSettings.log_queries_annotation_data_format))).isEqualTo((Object)GraphDatabaseSettings.AnnotationDataFormat.FLAT_JSON);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Use of deprecated setting 'db.logs.query.annotation_data_as_json_enabled'. It is replaced by"});
    }

    @Test
    void annotationDataAsJsonConflict() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().setRaw(Map.of("db.logs.query.annotation_data_as_json_enabled", "true", GraphDatabaseSettings.log_queries_annotation_data_format.name(), GraphDatabaseSettings.AnnotationDataFormat.CYPHER.name())).build();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((Comparable)((GraphDatabaseSettings.AnnotationDataFormat)config.get(GraphDatabaseSettings.log_queries_annotation_data_format))).isEqualTo((Object)GraphDatabaseSettings.AnnotationDataFormat.CYPHER);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Use of deprecated setting 'db.logs.query.annotation_data_as_json_enabled'. It is replaced by"}).containsMessages(new String[]{" is already configured, ignoring db.logs.query.annotation_data_as_json_enabled."});
    }
}

