/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ToolingMemoryCalculations;
import org.neo4j.io.os.OsBeanUtil;

class ToolingMemoryCalculationsTest {
    ToolingMemoryCalculationsTest() {
    }

    @Test
    void shouldCalculateCorrectMaxMemorySetting() {
        long freeMachineMemory = OsBeanUtil.getFreePhysicalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        Assumptions.assumeTrue((freeMachineMemory != -1L ? 1 : 0) != 0);
        int percent = 70;
        long memory = new ToolingMemoryCalculations(ToolingMemoryCalculations.NO_MONITOR).calculateMaxAvailableOffHeapMemoryFromPercent(percent, freeMachineMemory, maxMemory);
        long expected = Math.round((double)(freeMachineMemory - Math.min(maxMemory, freeMachineMemory / 2L)) * ((double)percent / 100.0));
        ((AbstractLongAssert)Assertions.assertThat((long)memory).as("Machine free memory: " + freeMachineMemory + ", max: " + maxMemory, new Object[0])).isEqualTo(expected);
    }
}

