/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.net.InetSocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;

class ConnectorPortRegisterTest {
    private final ConnectorPortRegister portRegister = new ConnectorPortRegister();

    ConnectorPortRegisterTest() {
    }

    @Test
    void shouldRegisterInetSocketAddress() {
        InetSocketAddress address = new InetSocketAddress(0);
        this.portRegister.register(ConnectorType.BOLT, address);
        this.verifyAddress(ConnectorType.BOLT, address.getHostString(), address.getPort());
    }

    @Test
    void shouldRegisterSocketAddress() {
        SocketAddress address = new SocketAddress("neo4j.com", 12345);
        this.portRegister.register(ConnectorType.BOLT, address);
        this.verifyAddress(ConnectorType.BOLT, address.getHostname(), address.getPort());
    }

    @Test
    void shouldDeregister() {
        SocketAddress address = new SocketAddress("neo4j.com", 42);
        this.portRegister.register(ConnectorType.BOLT, address);
        Assertions.assertNotNull((Object)this.portRegister.getLocalAddress(ConnectorType.BOLT));
        this.portRegister.deregister(ConnectorType.BOLT);
        Assertions.assertNull((Object)this.portRegister.getLocalAddress(ConnectorType.BOLT));
    }

    @Test
    void shouldReturnAddressByKey() {
        SocketAddress address1 = new SocketAddress("localhost", 7574);
        SocketAddress address2 = new SocketAddress("neo4j.com", 8989);
        SocketAddress address3 = new SocketAddress("8.8.8.8", 80);
        this.portRegister.register(ConnectorType.BOLT, address1);
        this.portRegister.register(ConnectorType.HTTP, address2);
        this.portRegister.register(ConnectorType.HTTPS, address3);
        this.verifyAddress(ConnectorType.BOLT, "localhost", 7574);
        this.verifyAddress(ConnectorType.HTTP, "neo4j.com", 8989);
        this.verifyAddress(ConnectorType.HTTPS, "8.8.8.8", 80);
    }

    private void verifyAddress(ConnectorType connectorType, String expectedHostname, int expectedPort) {
        HostnamePort expectedAddress = new HostnamePort(expectedHostname, expectedPort);
        Assertions.assertEquals((Object)expectedAddress, (Object)this.portRegister.getLocalAddress(connectorType));
    }
}

