/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public class ConfigBasedLookupTest {
    private static final NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
    private static final NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
    private static final NamedDatabaseId baz = DatabaseIdFactory.from((String)"baz", (UUID)UUID.randomUUID());
    private final Set<NamedDatabaseId> databases = Set.of(foo, bar, baz);
    private static final DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);

    @BeforeAll
    static void setup() {
        Mockito.when((Object)databaseIdRepository.getByName("foo")).thenReturn(Optional.of(foo));
        Mockito.when((Object)databaseIdRepository.getByName("bar")).thenReturn(Optional.of(bar));
        Mockito.when((Object)databaseIdRepository.getByName("baz")).thenReturn(Optional.of(baz));
    }

    @Test
    void withDefaultConfigDatabaseAreWritable() {
        ConfigBasedLookupFactory lookupFactory = new ConfigBasedLookupFactory(Config.defaults(), databaseIdRepository);
        ReadOnlyDatabases.Lookup lookup = lookupFactory.lookupReadOnlyDatabases();
        for (NamedDatabaseId db : this.databases) {
            Assertions.assertFalse((boolean)lookup.databaseIsReadOnly(db.databaseId()));
        }
    }

    @Test
    void readOnlyDefaultShouldIncludeAllDatabases() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.read_only_database_default, (Object)true);
        ConfigBasedLookupFactory lookupFactory = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases.Lookup lookup = lookupFactory.lookupReadOnlyDatabases();
        for (NamedDatabaseId db : this.databases) {
            Assertions.assertTrue((boolean)lookup.databaseIsReadOnly(db.databaseId()));
        }
    }

    @Test
    void readOnlyLookupShouldIncludeAllConfiguredDatabases() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.read_only_databases, Set.of(foo.name(), bar.name()));
        ConfigBasedLookupFactory lookupFactory = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases.Lookup lookup = lookupFactory.lookupReadOnlyDatabases();
        Assertions.assertFalse((boolean)lookup.databaseIsReadOnly(baz.databaseId()));
        Assertions.assertTrue((boolean)lookup.databaseIsReadOnly(foo.databaseId()));
        Assertions.assertTrue((boolean)lookup.databaseIsReadOnly(bar.databaseId()));
    }

    @Test
    void readOnlyLookupShouldExcludeWritableConfiguredDatabases() {
        Config config = Config.defaults(Map.of(GraphDatabaseSettings.read_only_database_default, true, GraphDatabaseSettings.writable_databases, Set.of("foo")));
        ConfigBasedLookupFactory lookupFactory = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases.Lookup lookup = lookupFactory.lookupReadOnlyDatabases();
        Assertions.assertFalse((boolean)lookup.databaseIsReadOnly(foo.databaseId()));
        Assertions.assertTrue((boolean)lookup.databaseIsReadOnly(bar.databaseId()));
        Assertions.assertTrue((boolean)lookup.databaseIsReadOnly(baz.databaseId()));
    }
}

