/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Set;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigReadOnlyDatabaseListener;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@ExtendWith(value={LifeExtension.class})
public class ConfigReadOnlyDatabaseListenerTest {
    @Inject
    private LifeSupport lifeSupport;

    @Test
    void configChangeShouldRefreshReadOnlyDatabases() {
        Config config = Config.defaults();
        ReadOnlyDatabases readOnlyDatabases = (ReadOnlyDatabases)Mockito.mock(ReadOnlyDatabases.class);
        ConfigReadOnlyDatabaseListener listener = new ConfigReadOnlyDatabaseListener(readOnlyDatabases, config);
        this.lifeSupport.add((Lifecycle)listener);
        config.setDynamic(GraphDatabaseSettings.read_only_database_default, (Object)true, "test");
        config.setDynamic(GraphDatabaseSettings.writable_databases, Set.of("foo", "bar"), "test");
        config.setDynamic(GraphDatabaseSettings.read_only_databases, Set.of("baz"), "test");
        ((ReadOnlyDatabases)Mockito.verify((Object)readOnlyDatabases, (VerificationMode)Mockito.atLeast((int)3))).refresh();
    }
}

