/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.ConfigPatternBuilder;

class ConfigPatternBuilderTest {
    private static final String[] unsupportedWildcards = new String[]{"[a-z]", ".", ".+", "+", "\\", "^", "&", "(a|b)", "[^1-9]", "\\d", "\\D", "\\s", "\\S", "\\w", "\\W"};

    ConfigPatternBuilderTest() {
    }

    @Test
    void shouldWorkWithoutWildcard() {
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks("foo", "foo");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks("foo", "", "Foo", "foO", "FOO", "fo", "fooo", " foo", "foo ", "fo ", "fo*", "fo?", "f00");
    }

    @Test
    void shouldWorkWithSingleQuestionMarkWildcard() {
        String single = "fo?";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(single, "fo", "foo", "fo1", "fo.", "fo ", "fo*", "fo?");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(single, "", "fooo", " foo", "foo ");
    }

    @Test
    void shouldWorkWithMultipleQuestionMarkWildcard() {
        String multipleIndependent = "?o?";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleIndependent, "foo", "1o1", "o", "fo", "of", "o*", "?o");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleIndependent, "", "fooo", " foo", "foo ", "afoo");
    }

    @Test
    void shouldWorkWithMultipleConsecutiveQuestionMarkWildcard() {
        String multipleConsecutive = "f??";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleConsecutive, "foo", "fo1", "fo.", "fo ", "fo*", "fo?", "f  ", "f99");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleConsecutive, "", "fooo", " foo", "foo ", "afoo");
    }

    @Test
    void shouldWorkWithAsteriskWildcard() {
        String single = "fo*";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(single, "foo", "fo1", "fo.", "fo ", "fo*", "fo?", "fooo", "foo ");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(single, "", "fo", " foo");
    }

    @Test
    void shouldWorkWithMultipleAsteriskWildcard() {
        String multipleIndependent = "*o*";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleIndependent, "foo", "1o1", "fooo", "*o*", "?o?", " foo", "foo ", "afoo");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleIndependent, "", "o", "fo", "of");
    }

    @Test
    void shouldWorkWithMultipleConsecutiveAsteriskWildcard() {
        String multipleConsecutive = "f**";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleConsecutive, "foo", "fo1", "fooo", "foo ", "fo.", "fo ", "fo*", "fo?", "f  ", "f99");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleConsecutive, "", "f", "fo", "afoo", " foo");
    }

    @Test
    void shouldWorkWithMultipleConsecutiveToAchieveMinimumCharsBehaviour() {
        String multipleConsecutive = "1*2**3***";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleConsecutive, "1a2bb3ccc", "122223222", "1323333333", "1       2       3        4");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleConsecutive, "", "123", "12 3  ", "123   3  2   23");
    }

    @Test
    void shouldWorkWithBothWildcards() {
        String multipleIndependent = "?o*";
        ConfigPatternBuilderTest.checkMatchesAndEscapingWorks(multipleIndependent, "o1", "foo", "1o1", "fooo", "*o*", "?o?", "foo ");
        ConfigPatternBuilderTest.checkDoesNotMatchAndEscapingWorks(multipleIndependent, "", "o", "fo", " foo", "afoo");
    }

    @Test
    void shouldWorkWithFlags() {
        ConfigPatternBuilderTest.assertMatches("foo", 2, "foo", "FOO", "Foo", "foO");
        ConfigPatternBuilderTest.assertDoesNotMatch("foo", 2, "", "fo", "fooo", " foo", "foo ", "fo ", "foo\n", "\nfoo", "fo*", "fo?");
        ConfigPatternBuilderTest.assertMatches("foo*", 32, "foo\n", "foo \n", "fooo\n", "foo\n\n", "foo\no");
        ConfigPatternBuilderTest.assertDoesNotMatch("foo*", 32, "foo", "\nfooo", "fo\noo", "\nfoo\n", "boo\n");
    }

    private static void assertNotMessedUpByUnsupportedWildcards(String pattern, int flags, String match, boolean expectedMatch) {
        for (String wildcard : unsupportedWildcards) {
            if (expectedMatch) {
                ConfigPatternBuilderTest.assertMatches(pattern + wildcard, flags, match + wildcard);
                ConfigPatternBuilderTest.assertMatches(wildcard + pattern, flags, wildcard + pattern);
                continue;
            }
            ConfigPatternBuilderTest.assertDoesNotMatch(pattern + wildcard, flags, match, match + wildcard, wildcard + match);
            ConfigPatternBuilderTest.assertDoesNotMatch(wildcard + pattern, flags, match, match + wildcard, wildcard + match);
        }
    }

    private static void checkMatchesAndEscapingWorks(String pattern, String ... expectedMatches) {
        ConfigPatternBuilderTest.assertMatches(pattern, 0, expectedMatches);
        for (String match : expectedMatches) {
            ConfigPatternBuilderTest.assertNotMessedUpByUnsupportedWildcards(pattern, 0, match, true);
        }
    }

    private static void assertMatches(String pattern, int flags, String ... expectedMatches) {
        Pattern p = ConfigPatternBuilder.patternFromConfigString((String)pattern, (int)flags);
        Assertions.assertThat((Object[])expectedMatches).allSatisfy(m -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)p.matcher((CharSequence)m).matches()).as(String.format("Pattern '%s' should match '%s' but does not. Java regex is %s", pattern, m, p), new Object[0])).isTrue());
    }

    private static void checkDoesNotMatchAndEscapingWorks(String pattern, String ... expectedMatches) {
        ConfigPatternBuilderTest.assertDoesNotMatch(pattern, 0, expectedMatches);
        for (String match : expectedMatches) {
            ConfigPatternBuilderTest.assertNotMessedUpByUnsupportedWildcards(pattern, 0, match, false);
        }
    }

    private static void assertDoesNotMatch(String pattern, int flags, String ... expectedMatches) {
        Pattern p = ConfigPatternBuilder.patternFromConfigString((String)pattern, (int)flags);
        Assertions.assertThat((Object[])expectedMatches).allSatisfy(m -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)p.matcher((CharSequence)m).matches()).as(String.format("Pattern '%s' should NOT match '%s' but does. Java regex is %s", pattern, m, p), new Object[0])).isFalse());
    }
}

