/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.helpers.DatabaseNamePattern;

class DatabaseNamePatternTest {
    DatabaseNamePatternTest() {
    }

    @Test
    void shouldNotGetAnErrorForAValidDatabaseName() {
        DatabaseNamePatternTest.assertValid("my.Vaild-D*b123?");
        DatabaseNamePatternTest.assertValid("my.Vaild-Db123");
    }

    @Test
    void shouldMatchWithProvidedDatabaseNames() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("???").matches("abc"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("****").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("?*??").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("cust*").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("*01").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("Widgets-customer-*-db1").matches("Widgets-customer-001-db1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("Widgets-customer-*-db?").matches("Widgets-customer-222-db5"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("Widgets-****-*-db?").matches("Widgets-customer-222-db5"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("c*01").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("c?st*tp").matches("Customer01tp"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("cust*tp?").matches("Customer01tp"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("database1").matches("database1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new DatabaseNamePattern("my.Vaild-D*b1?3").matches("my.Vaild-Daweeb123"));
    }

    @Test
    void shouldNotMatchWithProvidedDatabaseNames() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new DatabaseNamePattern("C?").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new DatabaseNamePattern("C?tomer01").matches("Customer01"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new DatabaseNamePattern("temp").matches("temp2"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new DatabaseNamePattern("r*r").matches("tur"));
    }

    @Test
    void shouldGetAnErrorForAnEmptyDatabaseName() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid(""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e.getMessage());
        Exception e2 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> DatabaseNamePatternTest.assertValid(null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e2.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithInvalidCharacters() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid("database%"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Database name 'database%' contains illegal characters. Use simple ascii characters, numbers, dots, question marks, asterisk and dashes.", (Object)e.getMessage());
        Exception e2 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid("data{base}"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Database name 'data{base}' contains illegal characters. Use simple ascii characters, numbers, dots, question marks, asterisk and dashes.", (Object)e2.getMessage());
        Exception e3 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid("data/base"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Database name 'data/base' contains illegal characters. Use simple ascii characters, numbers, dots, question marks, asterisk and dashes.", (Object)e3.getMessage());
        Exception e4 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid("data\u00e5\u00e4\u00f6"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Database name 'data\u00e5\u00e4\u00f6' contains illegal characters. Use simple ascii characters, numbers, dots, question marks, asterisk and dashes.", (Object)e4.getMessage());
    }

    @Test
    void shouldGetAnErrorForADatabaseNameWithInvalidLength() {
        Exception e1 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid(" "));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e1.getMessage());
        Exception e2 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid(""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The provided database name is empty.", (Object)e2.getMessage());
        Exception e3 = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> DatabaseNamePatternTest.assertValid("a" + RandomStringUtils.randomAscii((int)64)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The provided database name must have a length between 1 and 63 characters.", (Object)e3.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    void shouldGetExactDatabaseNames(List<String> names, Optional<Set<String>> expected) {
        Assertions.assertThat((Optional)DatabaseNamePattern.exactNames(names.stream().map(DatabaseNamePattern::new).toList())).isEqualTo(expected);
    }

    static Stream<Arguments> values() {
        return Stream.of(Arguments.of((Object[])new Object[]{List.of("foo"), Optional.of(Set.of("foo"))}), Arguments.of((Object[])new Object[]{List.of("foo", "bar"), Optional.of(Set.of("foo", "bar"))}), Arguments.of((Object[])new Object[]{List.of("foo", "foo"), Optional.of(Set.of("foo"))}), Arguments.of((Object[])new Object[]{List.of("foo?", "bar"), Optional.empty()}));
    }

    @Test
    void shouldMatchAnyPattern() {
        List<String> patterns = List.of("foo*", "foo", "foo?", "bar");
        Predicate match = DatabaseNamePattern.matchAny(patterns.stream().map(DatabaseNamePattern::new).toList());
        Assertions.assertThat((boolean)match.test("foo")).isTrue();
        Assertions.assertThat((boolean)match.test("bar")).isTrue();
        Assertions.assertThat((boolean)match.test("foobar")).isTrue();
        Assertions.assertThat((boolean)match.test("raboof")).isFalse();
    }

    private static void assertValid(String name) {
        new DatabaseNamePattern(name);
    }
}

