/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.helpers.GlobbingPattern;
import org.neo4j.string.Globbing;

class GlobbingPatternTest {
    GlobbingPatternTest() {
    }

    @Test
    void invalidGlobbingPatternShouldThrow() {
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new GlobbingPattern("invalid[globbing*pattern"));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("Invalid globbing pattern 'invalid[globbing*pattern'");
    }

    @Test
    void createShouldBeAbleToCreateMultiplePatterns() {
        List globbingPatterns = GlobbingPattern.create((String[])new String[]{"*pattern1", "pattern?2"});
        Assertions.assertThat((List)globbingPatterns).containsExactly((Object[])new GlobbingPattern[]{new GlobbingPattern("*pattern1"), new GlobbingPattern("pattern?2")});
    }

    @Test
    void patternMatchingWithGlobbingCharsShouldWork() {
        GlobbingPattern globbingPattern = new GlobbingPattern("pattern*1?.test");
        GlobbingPattern starsFirstLast = new GlobbingPattern("*pattern1.test*");
        GlobbingPattern questionMarks = new GlobbingPattern("?pattern1.test?");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)globbingPattern.matches("pattern11.test"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)globbingPattern.matches("patternstuff11.test"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)globbingPattern.matches("pattern1.test"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)globbingPattern.matches("pattern111test"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)starsFirstLast.matches("pattern1.test"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)starsFirstLast.matches("apattern1.testa"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)questionMarks.matches("apattern1.testa"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)questionMarks.matches("aapattern1.testaa"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)questionMarks.matches("pattern1.test"));
    }

    @Test
    void patternMatchingWithoutGlobbingCharsShouldWork() {
        GlobbingPattern empty = new GlobbingPattern("");
        GlobbingPattern space = new GlobbingPattern(" ");
        GlobbingPattern noGlobbing = new GlobbingPattern("full.name");
        GlobbingPattern all = new GlobbingPattern("*");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)empty.matches(""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)empty.matches(" "));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)empty.matches("a"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)space.matches(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)space.matches(" "));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)space.matches("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)all.matches(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)all.matches(" "));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)all.matches("a"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)noGlobbing.matches("full.name"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)noGlobbing.matches(""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)noGlobbing.matches("fullAname"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)noGlobbing.matches("Afull.name"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)noGlobbing.matches("full.nameA"));
    }

    private static Stream<Combination> combinations() {
        return Stream.of(new Combination(List.of(), List.of(), List.of()), new Combination(List.of("*"), List.of(), Combination.INPUTS), new Combination(List.of("*"), List.of("*"), List.of()), new Combination(List.of("*a"), List.of(), List.of("a", "A", "fulla", "fullA", "something.a", "something.A")), new Combination(List.of("*a"), List.of("fulla"), List.of("a", "A", "something.a", "something.A")), new Combination(List.of("*b"), List.of("*a"), List.of("b", "fullb")));
    }

    @ParameterizedTest
    @MethodSource(value={"combinations"})
    void testCompose(Combination combination) {
        Predicate predicate = Globbing.compose(combination.include(), combination.exclude());
        List actual = Combination.INPUTS.stream().filter(predicate).toList();
        Assertions.assertThat(actual).isEqualTo(combination.expected());
    }

    private record Combination(List<String> include, List<String> exclude, List<String> expected) {
        static final List<String> INPUTS = List.of("", " ", "a", "A", "fulla", "fullA", "something.a", "something.A", "b", "fullb");
    }
}

