/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;

class SocketAddressParserTest {
    SocketAddressParserTest() {
    }

    @Test
    void shouldCreateSocketAddressWithLeadingWhitespace() {
        String addressString = SocketAddressParserTest.whitespace(1) + "localhost:9999";
        SocketAddress address = SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
        Assertions.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assertions.assertEquals((int)9999, (int)address.getPort());
    }

    @Test
    void shouldCreateSocketAddressWithTrailingWhitespace() {
        String addressString = "localhost:9999" + SocketAddressParserTest.whitespace(2);
        SocketAddress address = SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
        Assertions.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assertions.assertEquals((int)9999, (int)address.getPort());
    }

    @Test
    void shouldFailToCreateSocketAddressWithMixedInWhitespace() {
        String addressString = "localhost" + SocketAddressParserTest.whitespace(1) + ":9999";
        Assertions.assertThrows(IllegalArgumentException.class, () -> SocketAddressParser.socketAddress((String)addressString, SocketAddress::new));
    }

    @Test
    void shouldFailToCreateSocketAddressWithNegativePort() {
        String addressString = "localhost:-10";
        Assertions.assertThrows(IllegalArgumentException.class, () -> SocketAddressParser.socketAddress((String)addressString, SocketAddress::new));
    }

    @Test
    void shouldFailToCreateSocketAddressWithNonNumericPort() {
        String addressString = "localhost:bolt";
        Assertions.assertThrows(IllegalArgumentException.class, () -> SocketAddressParser.socketAddress((String)addressString, SocketAddress::new));
    }

    @Test
    void shouldGetInvalidPortWhenMissingPort() {
        String addressString = "localhost";
        Assertions.assertEquals((int)-1, (int)SocketAddressParser.socketAddress((String)addressString, SocketAddress::new).getPort());
    }

    @Test
    void shouldGetInvalidPortWhenMissingPortWithTrailingColon() {
        String addressString = "localhost:";
        Assertions.assertEquals((int)-1, (int)SocketAddressParser.socketAddress((String)addressString, SocketAddress::new).getPort());
    }

    @Test
    void shouldGetInvalidPortWhenMissingPortIPv6Address() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"fe80:1:2:3:4::5", SocketAddress::new);
        Assertions.assertEquals((int)-1, (int)socketAddress.getPort());
    }

    @Test
    void shouldGetPortWhenOnlyPortProvided() {
        String addressString = ":1";
        Assertions.assertEquals((int)1, (int)SocketAddressParser.socketAddress((String)addressString, SocketAddress::new).getPort());
        Assertions.assertEquals((int)1, (int)SocketAddressParser.socketAddress((String)addressString, (int)123, SocketAddress::new).getPort());
    }

    @Test
    void shouldGetDefaultPortWhenMissingPort() {
        String addressString = "localhost";
        Assertions.assertEquals((int)123, (int)SocketAddressParser.socketAddress((String)addressString, (int)123, SocketAddress::new).getPort());
    }

    @Test
    void shouldGetDefaultPortWhenMissingPortIPv6Address() {
        String addressString = "fe80:1:2:3:4::5";
        Assertions.assertEquals((int)123, (int)SocketAddressParser.socketAddress((String)addressString, (int)123, SocketAddress::new).getPort());
    }

    @Test
    void shouldGetDefaultPortWhenMissingPortWithTrailingColon() {
        String addressString = "localhost:";
        Assertions.assertEquals((int)123, (int)SocketAddressParser.socketAddress((String)addressString, (int)123, SocketAddress::new).getPort());
    }

    @Test
    void shouldCreateSocketAddressWithPortZero() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"my.domain:0", SocketAddress::new);
        Assertions.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)0, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"my.domain:0", (Object)socketAddress.toString());
    }

    @Test
    void shouldSupportDomainNameWithPort() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"my.domain:123", SocketAddress::new);
        Assertions.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"my.domain:123", (Object)socketAddress.toString());
    }

    @Test
    void shouldSupportWildcardWithPort() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"0.0.0.0:123", SocketAddress::new);
        Assertions.assertEquals((Object)"0.0.0.0", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"0.0.0.0:123", (Object)socketAddress.toString());
        Assertions.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportPortOnly() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", (String)":123", (String)"my.domain", (int)456, SocketAddress::new);
        Assertions.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"my.domain:123", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportDefaultValue() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"my.domain", (int)456, SocketAddress::new);
        Assertions.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)456, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"my.domain:456", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportDefaultWildcard() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"0.0.0.0", (int)456, SocketAddress::new);
        Assertions.assertEquals((Object)"0.0.0.0", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)456, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"0.0.0.0:456", (Object)socketAddress.toString());
        Assertions.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportDefaultIPv6Wildcard() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"::", (int)456, SocketAddress::new);
        Assertions.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)456, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[::]:456", (Object)socketAddress.toString());
        Assertions.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportDefaultIPv6Value() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"fe80:1:2::4", (int)456, SocketAddress::new);
        Assertions.assertEquals((Object)"fe80:1:2::4", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)456, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[fe80:1:2::4]:456", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldNotUseDefaultsWhenSettingValueSupplied() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", (String)"[fe80:3:4::6]:456", (String)"fe80:1:2::4", (int)123, SocketAddress::new);
        Assertions.assertEquals((Object)"fe80:3:4::6", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)456, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[fe80:3:4::6]:456", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6Wildcard() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[::]:123", SocketAddress::new);
        Assertions.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[::]:123", (Object)socketAddress.toString());
        Assertions.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6Localhost() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[::1]:123", SocketAddress::new);
        Assertions.assertEquals((Object)"::1", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[::1]:123", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6WithZoneId() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[fe80::b279:2f%en0]:123", SocketAddress::new);
        Assertions.assertEquals((Object)"fe80::b279:2f%en0", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[fe80::b279:2f%en0]:123", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6AddressWithBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[fe80:1:2:3:4::5]:123", SocketAddress::new);
        Assertions.assertEquals((Object)"fe80:1:2:3:4::5", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[fe80:1:2:3:4::5]:123", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6AddressWithoutBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"fe80:1:2:3:4::5:123", SocketAddress::new);
        Assertions.assertEquals((Object)"fe80:1:2:3:4::5", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[fe80:1:2:3:4::5]:123", (Object)socketAddress.toString());
        Assertions.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6WildcardWithoutBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)":::123", SocketAddress::new);
        Assertions.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assertions.assertEquals((int)123, (int)socketAddress.getPort());
        Assertions.assertEquals((Object)"[::]:123", (Object)socketAddress.toString());
        Assertions.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    void shouldSupportIPv6SpecialAddresses() {
        SocketAddress localhost = SocketAddressParser.socketAddress((String)"::1", SocketAddress::new);
        SocketAddress unspecified = SocketAddressParser.socketAddress((String)"::", SocketAddress::new);
        Assertions.assertEquals((Object)"::1", (Object)localhost.getHostname());
        Assertions.assertTrue((localhost.getPort() < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"::", (Object)unspecified.getHostname());
        Assertions.assertTrue((unspecified.getPort() < 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldNotAllowURIs() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SocketAddressParser.socketAddress((String)"neo4j://18.117.195.94:7687", SocketAddress::new));
    }

    private static String whitespace(int numberOfWhitespaces) {
        return " ".repeat(numberOfWhitespaces);
    }
}

