/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.pagecache;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.pagecache.buffer.NativeIOBuffer;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class ConfigurableIOBufferFactoryTest {
    ConfigurableIOBufferFactoryTest() {
    }

    @Test
    void createDisabledBufferCanBeDisabled() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_buffered_flush_enabled, (Object)false);
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (NativeIOBuffer ioBuffer = bufferFactory.createBuffer();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.isEnabled());
        }
    }

    @Test
    void disabledBufferDoesNotConsumeMemory() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_buffered_flush_enabled, (Object)false);
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (NativeIOBuffer ioBuffer = bufferFactory.createBuffer();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.isEnabled());
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        }
    }

    @Test
    void defaultBufferCreation() {
        Config config = Config.defaults();
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(config, (MemoryTracker)memoryTracker);
        try (NativeIOBuffer ioBuffer = bufferFactory.createBuffer();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.isEnabled());
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        }
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
    }
}

