/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.pagecache;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBuffer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class ConfigurableIOBufferTest {
    ConfigurableIOBufferTest() {
    }

    @Test
    void ioBufferEnabledByDefault() {
        Config config = Config.defaults();
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.isEnabled());
        }
    }

    @Test
    void allocatedBufferShouldHavePageAlignedAddress() {
        Config config = Config.defaults();
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Assertions.assertThat((long)(ioBuffer.getAddress() % 8192L)).isZero();
        }
    }

    @Test
    void bufferPoolMemoryRegisteredInMemoryPool() {
        Config config = Config.defaults();
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)memoryTracker);){
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo((long)(8192 * (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue() + 8192));
        }
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
    }

    @Test
    void canTryToCloseBufferSeveralTimes() {
        Config config = Config.defaults();
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)memoryTracker);
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo((long)(8192 * (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue() + 8192));
        ioBuffer.close();
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        ioBuffer.close();
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        ioBuffer.close();
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
    }

    @Test
    void bufferSizeCanBeConfigured() {
        int customPageSize = 2;
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages, (Object)customPageSize);
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)memoryTracker);){
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo((long)(8192 * customPageSize + 8192));
        }
    }

    @Test
    void bufferCapacityLimit() {
        int customPageSize = 5;
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages, (Object)customPageSize);
        DefaultScopedMemoryTracker memoryTracker = new DefaultScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)memoryTracker);){
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo((long)(8192 * customPageSize + 8192));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.hasMoreCapacity(0, 1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.hasMoreCapacity(8192, 8192));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.hasMoreCapacity(16384, 8192));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.hasMoreCapacity(24576, 8192));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.hasMoreCapacity(32768, 8192));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.hasMoreCapacity(32768, 8193));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.hasMoreCapacity(40960, 8192));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.hasMoreCapacity(49152, 8192));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.hasMoreCapacity(57344, 8192));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.hasMoreCapacity(65536, 8192));
        }
    }

    @Test
    void allocationFailureMakesBufferDisabled() {
        int customPageSize = 5;
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages, (Object)customPageSize);
        PoisonedMemoryTracker memoryTracker = new PoisonedMemoryTracker();
        try (ConfigurableIOBuffer ioBuffer = new ConfigurableIOBuffer(config, (MemoryTracker)memoryTracker);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)memoryTracker.isExceptionThrown());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.isEnabled());
        }
    }

    private static class PoisonedMemoryTracker
    extends LocalMemoryTracker {
        private boolean exceptionThrown;

        private PoisonedMemoryTracker() {
        }

        public void allocateNative(long bytes) {
            this.exceptionThrown = true;
            throw new RuntimeException("Poison");
        }

        public boolean isExceptionThrown() {
            return this.exceptionThrown;
        }
    }
}

