/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.ssl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.string.SecureString;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class SslPolicyConfigValidatorTest {
    @Inject
    private TestDirectory testDirectory;

    SslPolicyConfigValidatorTest() {
    }

    @Test
    void shouldFindPolicyDefaults() {
        SslPolicyConfig policyConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        Path homeDir = this.testDirectory.directory("home");
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toAbsolutePath()).set(policyConfig.base_directory, (Object)Path.of("certificates/testing", new String[0])).build();
        Path privateKey = homeDir.resolve("certificates/testing/private.key");
        Path publicCertificate = homeDir.resolve("certificates/testing/public.crt");
        Path trustedDir = homeDir.resolve("certificates/testing/trusted");
        Path revokedDir = homeDir.resolve("certificates/testing/revoked");
        Path privateKeyFromConfig = (Path)config.get(policyConfig.private_key);
        Path publicCertificateFromConfig = (Path)config.get(policyConfig.public_certificate);
        Path trustedDirFromConfig = (Path)config.get(policyConfig.trusted_dir);
        Path revokedDirFromConfig = (Path)config.get(policyConfig.revoked_dir);
        SecureString privateKeyPassword = (SecureString)config.get(policyConfig.private_key_password);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        org.junit.jupiter.api.Assertions.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        org.junit.jupiter.api.Assertions.assertNull((Object)privateKeyPassword);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)trustAll);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList("TLSv1.2"), (Object)tlsVersions);
        org.junit.jupiter.api.Assertions.assertNull((Object)ciphers);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ClientAuth.REQUIRE, (Object)clientAuth);
    }

    @Test
    void shouldFindPolicyOverrides() {
        Config.Builder builder = Config.newBuilder();
        SslPolicyConfig policyConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        Path homeDir = this.testDirectory.directory("home");
        builder.set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toAbsolutePath());
        builder.set(policyConfig.base_directory, (Object)Path.of("certificates/testing", new String[0]));
        Path privateKey = this.testDirectory.directory("path/to/my.key");
        Path publicCertificate = this.testDirectory.directory("path/to/my.crt");
        Path trustedDir = this.testDirectory.directory("some/other/path/to/trusted");
        Path revokedDir = this.testDirectory.directory("some/other/path/to/revoked");
        builder.set(policyConfig.private_key, (Object)privateKey.toAbsolutePath());
        builder.set(policyConfig.public_certificate, (Object)publicCertificate.toAbsolutePath());
        builder.set(policyConfig.trusted_dir, (Object)trustedDir.toAbsolutePath());
        builder.set(policyConfig.revoked_dir, (Object)revokedDir.toAbsolutePath());
        builder.set(policyConfig.trust_all, (Object)true);
        builder.set(policyConfig.private_key_password, (Object)new SecureString("setecastronomy"));
        builder.set(policyConfig.tls_versions, List.of("TLSv1.1", "TLSv1.2"));
        builder.set(policyConfig.ciphers, List.of("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"));
        builder.set(policyConfig.client_auth, (Object)ClientAuth.OPTIONAL);
        Config config = builder.build();
        Path privateKeyFromConfig = (Path)config.get(policyConfig.private_key);
        Path publicCertificateFromConfig = (Path)config.get(policyConfig.public_certificate);
        Path trustedDirFromConfig = (Path)config.get(policyConfig.trusted_dir);
        Path revokedDirFromConfig = (Path)config.get(policyConfig.revoked_dir);
        SecureString privateKeyPassword = (SecureString)config.get(policyConfig.private_key_password);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        org.junit.jupiter.api.Assertions.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)trustAll);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"setecastronomy", (Object)privateKeyPassword.getString());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("TLSv1.1", "TLSv1.2"), (Object)tlsVersions);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"), (Object)ciphers);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ClientAuth.OPTIONAL, (Object)clientAuth);
    }

    @Test
    void shouldAcceptAllValidPemPolicyKeys() {
        SslPolicyConfig sslPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.TESTING);
        Config.Builder builder = Config.newBuilder().set(sslPolicy.base_directory, (Object)Path.of("xyz", new String[0])).set(sslPolicy.revoked_dir, (Object)Path.of("xyz", new String[0])).set(sslPolicy.trust_all, (Object)false).set(sslPolicy.client_auth, (Object)ClientAuth.NONE).set(sslPolicy.tls_versions, List.of("xyz")).set(sslPolicy.ciphers, List.of("xyz")).set(sslPolicy.verify_hostname, (Object)true).set(sslPolicy.private_key, (Object)Path.of("xyz", new String[0])).set(sslPolicy.public_certificate, (Object)Path.of("xyz", new String[0])).set(sslPolicy.trusted_dir, (Object)Path.of("xyz", new String[0])).set(sslPolicy.private_key_password, (Object)new SecureString("xyz"));
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((Config.Builder)builder).build());
    }

    @Test
    void shouldThrowOnUnknownPolicySetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, Arrays.asList("dbms.ssl.policy.testing.trust_all=xyz", "dbms.ssl.policy.testing.color=blue"), new OpenOption[0]);
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().fromFile(confFile).build());
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Error evaluating value for setting"});
    }

    @Test
    void shouldThrowOnDirectPolicySetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, Arrays.asList("dbms.ssl.policy.base_directory.trust_all=xyz", "dbms.ssl.policy.base_directory=path"), new OpenOption[0]);
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).fromFile(confFile);
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((Config.Builder)builder).build());
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"No declared setting with name: dbms.ssl.policy."});
    }

    @Test
    void shouldIgnoreUnknownNonPolicySettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, Arrays.asList("dbms.ssl.unknown=xyz", "dbms.ssl.something=xyz", "dbms.unrelated.totally=xyz"), new OpenOption[0]);
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().set(GraphDatabaseSettings.strict_config_validation, (Object)true).fromFile(confFile).build());
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Unrecognized setting"});
    }
}

